(function($) {
	"use strict";

	var iconKeyUpTimeout = null;

	
	//Map Icons
	$('.wpb_edit_form_elements .mapicon_icon_field').each(function() {
		var paramValue = $(this).val();
		var paramName = $(this).data('param-name');
		$(this).prev().html('<span class="map-icon map-icon-' + paramValue + '"></span>');
	}).on('keyup', function() {
		var paramValue = $(this).val();
		var currentIcon = '.map-icon-' + paramValue;
		$(this).prev().html('<span class="map-icon map-icon-' + paramValue + '"></span>');
		$(this).next('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window').children('.map-icon').removeClass('active');
		$(this).next('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window').find($(currentIcon)).addClass('active');
		if ( iconKeyUpTimeout != null ) {
			clearTimeout( iconKeyUpTimeout );
			iconKeyUpTimeout = null;
		}
	});

	$('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window').on('click', '.map-icon', function() {
		var $field = $(this).parents('.ttbase-mapicon-icon-select-window').parent().find('input');
		$('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window .map-icon').removeClass('active');
		if ( $(this).data('name') == 'clear' ) {
			$field.val('').prev().html('');
		} else {
			$(this).addClass('active');
			$field.val($(this).data('name')).prev().html('<span class="map-icon map-icon-' + $field.val() + '"></span>');
		}
	});
	$('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window').on('click', '.fa', function() {
		var $field = $(this).parents('.ttbase-mapicon-icon-select-window').parent().find('input');
		$('.wpb_edit_form_elements .mapicon_icon_field ~ .ttbase-mapicon-icon-select-window .map-icon').removeClass('active');
		if ( $(this).data('name') == 'clear' ) {
			$field.val('').prev().html('');
		}
	});

	$('.wpb_edit_form_elements .ttbase-mapicon-icon-filter').change(function() {
		var $field = $(this).parent().find('input');
		if ( $(this).val() == '' || $(this).data('name') == 'clear' ) {
			// nothing
		} else if ( $(this).val() == 'all' ) {
			$field.val('').trigger('keyup');
		} else {
			$field.val($(this).val()).trigger('keyup');
		}
	});

})(jQuery);