<?php 
	global $woocommerce;
	$cart_url = $woocommerce->cart->get_cart_url();
	$checkout_url = $woocommerce->cart->get_checkout_url();
?>

<div class="header-cart">
    <a href="<?php echo esc_url($cart_url); ?>" class="cart">
        <i class="icon-shopping_cart"></i>
        <span class="label number"><span class="count"><?php echo htmlspecialchars_decode($woocommerce->cart->get_cart_contents_count()); ?></span></span>
        <span class="title"><?php esc_html_e('Shopping Cart','yogax'); ?></span>
    </a>
    
    <div class="function">
        <div class="widget">
        
            <h6 class="title"><?php esc_html_e('Shopping Cart','yogax'); ?></h6>
            
            <ul class="cart-overview">
            
	            <?php foreach ($woocommerce->cart->cart_contents as $cart_item_key => $cart_item) : ?>
	            
	            	<?php $_product = $cart_item['data']; ?>
	            	
	                <li>
	                    <a href="<?php echo get_permalink($cart_item['product_id']); ?>">
	                        <?php echo get_the_post_thumbnail($cart_item['product_id'], 'shop_thumbnail'); ?>
	                        <div class="description">
	                            <span class="product-title"><?php echo apply_filters('woocommerce_cart_widget_product_title', $_product->get_title(), $_product); ?></span>
	                            <span class="price number"><?php echo wc_price($_product->get_price()); ?></span>
	                        </div>
	                    </a>
	                </li>
	                
	            <?php endforeach; ?>

            </ul>
            
            <hr>
            
            <div class="cart-controls">
                <a class="ttbase-button btn-small btn-primary style-1" href="<?php echo esc_url($checkout_url); ?>"><span><?php esc_html_e('Checkout','yogax'); ?></span></a>
                <div class="pull-right">
                    <span class="cart-total"><?php esc_html_e('Total','yogax'); ?></span>
                    <span class="number"><?php echo htmlspecialchars_decode($woocommerce->cart->get_cart_total()); ?></span>
                </div>
            </div>
            
        </div>
    </div>
    
</div>