<?php

if ( ! class_exists( 'Yogax_Ext_Shortcodes' ) ) {

	class Yogax_Ext_Shortcodes {

		/**
		 * Main Constructor
		 */
		function __construct() {

			// Define path
			$this->dir_path = plugin_dir_path( __FILE__ );

			// Actions
			add_action( 'wp_enqueue_scripts', array( $this, 'yogax_ext_shortcodes_load_scripts' ) );
			
			// The actual shortcodes
			require_once( $this->dir_path .'/parts/sc_init.php' );
			
			// Init Visual Composer
			require_once( $this->dir_path .'/parts/vc_init.php' );

		}


		/**
		 * Registers/Enqueues all scripts and styles
		 */
		function yogax_ext_shortcodes_load_scripts() {

			// Define js directory
			$js_dir = plugin_dir_url( __FILE__ ) . 'js/';

			// JS
			wp_register_script('yogax-class', $js_dir . 'yogax-class.min.js', array( 'jquery', 'yogax-scripts' ) );
			wp_register_script('yogax-trainer', $js_dir . 'yogax-trainer.min.js', array( 'jquery', 'yogax-scripts' ) );
			
		}
		
		
	}

	// Start things up
	$yogax_ext_shortcodes = new Yogax_Ext_Shortcodes();

}