<?php
//custom post type - weekdays
function yogax_ext_weekdays_init()
{
	$labels = array(
		'name' => esc_attr_x('Weekdays', 'post type general name', 'ttbase-framework'),
		'singular_name' => esc_attr_x('Day', 'post type singular name', 'ttbase-framework'),
		'add_new' => esc_attr_x('Add New', 'yogax_ext_day', 'ttbase-framework'),
		'add_new_item' => esc_attr__('Add New Day', 'ttbase-framework'),
		'edit_item' => esc_attr__('Edit Day', 'ttbase-framework'),
		'new_item' => esc_attr__('New Day', 'ttbase-framework'),
		'all_items' => esc_attr__('All Weekdays', 'ttbase-framework'),
		'view_item' => esc_attr__('View Day', 'ttbase-framework'),
		'search_items' => esc_attr__('Search Weekdays', 'ttbase-framework'),
		'not_found' =>  esc_attr__('No weekdays found', 'ttbase-framework'),
		'not_found_in_trash' => esc_attr__('No weekdays found in Trash', 'ttbase-framework'), 
		'parent_item_colon' => '',
		'menu_name' => esc_attr__("Weekdays", 'ttbase-framework')
	);
	$args = array(  
		"labels" => $labels, 
		"public" => true,  
		"show_ui" => true,  
		"capability_type" => "post",  
		"menu_position" => 36,
		"hierarchical" => false,  
		"rewrite" => true,  
		"supports" => array("title", "page-attributes")
	);
	register_post_type("yogax_weekdays", $args);
}  
add_action("init", "yogax_ext_weekdays_init"); 

//custom weekdays items list
function yogax_ext_weekdays_edit_columns($columns)
{
	$columns = array(  
		"cb" => "<input type=\"checkbox\" />",  
		"title" => esc_attr_x('Day name', 'post type singular name', 'ttbase-framework'),   
		"date" => esc_attr__('Date', 'ttbase-framework')
	);    

	return $columns;  
}  
add_filter("manage_edit-yogax_ext_weekdays_columns", "yogax_ext_weekdays_edit_columns");
?>