<?php
/**
 * Useful common functions
 */

// Return correct class for the font awesome icons
function ttbase_framework_shortcodes_font_icon_class( $icon = null ) {
	if ( ! $icon ) {
		return;
	}
	if ( 'None' == $icon || 'none' == $icon ) {
		$icon = null;
	}
	$icon = str_replace( 'fa-', '', $icon );
	if ( 'beaker' == $icon ) {
		$icon = 'flask';
	}
	if ( 'move' == $icon ) {
		$icon = 'arrows';
	}
	if ( 'lightbulb' == $icon ) {
		$icon = 'lightbulb-o';
	}
	if ( 'picture' == $icon ) {
		$icon = 'picture-o';
	}
	if ( 'file-text' == $icon ) {
		$icon = 'file-text-o';
	}
	if ( 'file-alt' == $icon ) {
		$icon = 'file-o';
	}
	$icon = 'fa fa-'. $icon;
	$icon = apply_filters( 'ttbase_framework_shortcodes_font_icon_class', $icon );
	return $icon;
}
// Return correct class for the map icons
function ttbase_framework_mapicon_font_icon_class( $icon = null ) {
	if ( ! $icon ) {
		return;
	}
	if ( 'None' == $icon || 'none' == $icon ) {
		$icon = null;
	}
	$icon = str_replace( 'map-icon-', '', $icon );
	
	$icon = 'map-icon map-icon-'. $icon;
	$icon = apply_filters( 'ttbase_framework_mapicon_font_icon_class', $icon );
	return $icon;
}
// Return correct class for the iconsmind icons
function ttbase_framework_shortcodes_iconsmind_font_icon_class( $icon = null ) {
	if ( ! $icon ) {
		return;
	}
	if ( 'None' == $icon || 'none' == $icon ) {
		$icon = null;
	}
	$icon = str_replace( 'im-', '', $icon );
	
	$icon = 'im im-'. $icon;
	$icon = apply_filters( 'ttbase_framework_shortcodes_iconsmind_font_icon_class', $icon );
	return $icon;
}
// Return correct class for the streamline icons
function ttbase_framework_shortcodes_streamline_font_icon_class( $icon = null ) {
	if ( ! $icon ) {
		return;
	}
	if ( 'None' == $icon || 'none' == $icon ) {
		$icon = null;
	}
	$icon = str_replace( 'sl-', '', $icon );
	
	$icon = 'sl sl-'. $icon;
	$icon = apply_filters( 'ttbase_framework_shortcodes_streamline_font_icon_class', $icon );
	return $icon;
}
// Font Icons
function ttbase_framework_shortcodes_font_icons_array() {
	$font_icons=array( esc_html__( 'None', 'ttbase-framework' ) => 'none', 'adjust'=>'adjust','anchor'=>'anchor','archive'=>'archive','arrows'=>'arrows','arrows-h'=>'arrows-h','arrows-v'=>'arrows-v','asterisk'=>'asterisk','automobile'=>'automobile','ban'=>'ban','bank'=>'bank','bar-chart-o'=>'bar-chart-o','barcode'=>'barcode','bars'=>'bars','beer'=>'beer','bell'=>'bell','bell-o'=>'bell-o','bolt'=>'bolt','bomb'=>'bomb','book'=>'book','bookmark'=>'bookmark','bookmark-o'=>'bookmark-o','briefcase'=>'briefcase','bug'=>'bug','building'=>'building','building-o'=>'building-o','bullhorn'=>'bullhorn','bullseye'=>'bullseye','cab'=>'cab','calendar'=>'calendar','calendar-o'=>'calendar-o','camera'=>'camera','camera-retro'=>'camera-retro','car'=>'car','caret-square-o-down'=>'caret-square-o-down','caret-square-o-left'=>'caret-square-o-left','caret-square-o-right'=>'caret-square-o-right','caret-square-o-up'=>'caret-square-o-up','certificate'=>'certificate','check'=>'check','check-circle'=>'check-circle','check-circle-o'=>'check-circle-o','check-square'=>'check-square','check-square-o'=>'check-square-o','child'=>'child','circle'=>'circle','circle-o'=>'circle-o','circle-o-notch'=>'circle-o-notch','circle-thin'=>'circle-thin','clock-o'=>'clock-o','cloud'=>'cloud','cloud-download'=>'cloud-download','cloud-upload'=>'cloud-upload','code'=>'code','code-fork'=>'code-fork','coffee'=>'coffee','cog'=>'cog','cogs'=>'cogs','comment'=>'comment','comment-o'=>'comment-o','comments'=>'comments','comments-o'=>'comments-o','compass'=>'compass','credit-card'=>'credit-card','crop'=>'crop','crosshairs'=>'crosshairs','cube'=>'cube','cubes'=>'cubes','cutlery'=>'cutlery','dashboard'=>'dashboard','database'=>'database','desktop'=>'desktop','dot-circle-o'=>'dot-circle-o','download'=>'download','edit'=>'edit','ellipsis-h'=>'ellipsis-h','ellipsis-v'=>'ellipsis-v','envelope'=>'envelope','envelope-o'=>'envelope-o','envelope-square'=>'envelope-square','eraser'=>'eraser','exchange'=>'exchange','exclamation'=>'exclamation','exclamation-circle'=>'exclamation-circle','exclamation-triangle'=>'exclamation-triangle','external-link'=>'external-link','external-link-square'=>'external-link-square','eye'=>'eye','eye-slash'=>'eye-slash','fax'=>'fax','female'=>'female','fighter-jet'=>'fighter-jet','file-archive-o'=>'file-archive-o','file-audio-o'=>'file-audio-o','file-code-o'=>'file-code-o','file-excel-o'=>'file-excel-o','file-image-o'=>'file-image-o','file-movie-o'=>'file-movie-o','file-pdf-o'=>'file-pdf-o','file-photo-o'=>'file-photo-o','file-picture-o'=>'file-picture-o','file-powerpoint-o'=>'file-powerpoint-o','file-sound-o'=>'file-sound-o','file-video-o'=>'file-video-o','file-word-o'=>'file-word-o','file-zip-o'=>'file-zip-o','film'=>'film','filter'=>'filter','fire'=>'fire','fire-extinguisher'=>'fire-extinguisher','flag'=>'flag','flag-checkered'=>'flag-checkered','flag-o'=>'flag-o','flash'=>'flash','flask'=>'flask','folder'=>'folder','folder-o'=>'folder-o','folder-open'=>'folder-open','folder-open-o'=>'folder-open-o','frown-o'=>'frown-o','gamepad'=>'gamepad','gavel'=>'gavel','gear'=>'gear','gears'=>'gears','gift'=>'gift','glass'=>'glass','globe'=>'globe','graduation-cap'=>'graduation-cap','group'=>'group','hdd-o'=>'hdd-o','headphones'=>'headphones','heart'=>'heart','heart-o'=>'heart-o','history'=>'history','home'=>'home','image'=>'image','inbox'=>'inbox','info'=>'info','info-circle'=>'info-circle','institution'=>'institution','key'=>'key','keyboard-o'=>'keyboard-o','language'=>'language','laptop'=>'laptop','leaf'=>'leaf','legal'=>'legal','lemon-o'=>'lemon-o','level-down'=>'level-down','level-up'=>'level-up','life-bouy'=>'life-bouy','life-ring'=>'life-ring','life-saver'=>'life-saver','lightbulb-o'=>'lightbulb-o','location-arrow'=>'location-arrow','lock'=>'lock','magic'=>'magic','magnet'=>'magnet','mail-forward'=>'mail-forward','mail-reply'=>'mail-reply','mail-reply-all'=>'mail-reply-all','male'=>'male','map-marker'=>'map-marker','meh-o'=>'meh-o','microphone'=>'microphone','microphone-slash'=>'microphone-slash','minus'=>'minus','minus-circle'=>'minus-circle','minus-square'=>'minus-square','minus-square-o'=>'minus-square-o','mobile'=>'mobile','mobile-phone'=>'mobile-phone','money'=>'money','moon-o'=>'moon-o','mortar-board'=>'mortar-board','music'=>'music','navicon'=>'navicon','paper-plane'=>'paper-plane','paper-plane-o'=>'paper-plane-o','paw'=>'paw','pencil'=>'pencil','pencil-square'=>'pencil-square','pencil-square-o'=>'pencil-square-o','phone'=>'phone','phone-square'=>'phone-square','photo'=>'photo','picture-o'=>'picture-o','plane'=>'plane','plus'=>'plus','plus-circle'=>'plus-circle','plus-square'=>'plus-square','plus-square-o'=>'plus-square-o','power-off'=>'power-off','print'=>'print','puzzle-piece'=>'puzzle-piece','qrcode'=>'qrcode','question'=>'question','question-circle'=>'question-circle','quote-left'=>'quote-left','quote-right'=>'quote-right','random'=>'random','recycle'=>'recycle','refresh'=>'refresh','reorder'=>'reorder','reply'=>'reply','reply-all'=>'reply-all','retweet'=>'retweet','road'=>'road','rocket'=>'rocket','rss'=>'rss','rss-square'=>'rss-square','search'=>'search','search-minus'=>'search-minus','search-plus'=>'search-plus','send'=>'send','send-o'=>'send-o','share'=>'share','share-alt'=>'share-alt','share-alt-square'=>'share-alt-square','share-square'=>'share-square','share-square-o'=>'share-square-o','shield'=>'shield','shopping-cart'=>'shopping-cart','sign-in'=>'sign-in','sign-out'=>'sign-out','signal'=>'signal','sitemap'=>'sitemap','sliders'=>'sliders','smile-o'=>'smile-o','sort'=>'sort','sort-alpha-asc'=>'sort-alpha-asc','sort-alpha-desc'=>'sort-alpha-desc','sort-amount-asc'=>'sort-amount-asc','sort-amount-desc'=>'sort-amount-desc','sort-asc'=>'sort-asc','sort-desc'=>'sort-desc','sort-down'=>'sort-down','sort-numeric-asc'=>'sort-numeric-asc','sort-numeric-desc'=>'sort-numeric-desc','sort-up'=>'sort-up','space-shuttle'=>'space-shuttle','spinner'=>'spinner','spoon'=>'spoon','square'=>'square','square-o'=>'square-o','star'=>'star','star-half'=>'star-half','star-half-empty'=>'star-half-empty','star-half-full'=>'star-half-full','star-half-o'=>'star-half-o','star-o'=>'star-o','suitcase'=>'suitcase','sun-o'=>'sun-o','support'=>'support','tablet'=>'tablet','tachometer'=>'tachometer','tag'=>'tag','tags'=>'tags','tasks'=>'tasks','taxi'=>'taxi','terminal'=>'terminal','thumb-tack'=>'thumb-tack','thumbs-down'=>'thumbs-down','thumbs-o-down'=>'thumbs-o-down','thumbs-o-up'=>'thumbs-o-up','thumbs-up'=>'thumbs-up','ticket'=>'ticket','times'=>'times','times-circle'=>'times-circle','times-circle-o'=>'times-circle-o','tint'=>'tint','toggle-down'=>'toggle-down','toggle-left'=>'toggle-left','toggle-right'=>'toggle-right','toggle-up'=>'toggle-up','trash-o'=>'trash-o','tree'=>'tree','trophy'=>'trophy','truck'=>'truck','umbrella'=>'umbrella','university'=>'university','unlock'=>'unlock','unlock-alt'=>'unlock-alt','unsorted'=>'unsorted','upload'=>'upload','user'=>'user','users'=>'users','video-camera'=>'video-camera','volume-down'=>'volume-down','volume-off'=>'volume-off','volume-up'=>'volume-up','warning'=>'warning','wheelchair'=>'wheelchair','wrench'=>'wrench','file'=>'file','file-archive-o'=>'file-archive-o','file-audio-o'=>'file-audio-o','file-code-o'=>'file-code-o','file-excel-o'=>'file-excel-o','file-image-o'=>'file-image-o','file-movie-o'=>'file-movie-o','file-o'=>'file-o','file-pdf-o'=>'file-pdf-o','file-photo-o'=>'file-photo-o','file-picture-o'=>'file-picture-o','file-powerpoint-o'=>'file-powerpoint-o','file-sound-o'=>'file-sound-o','file-text'=>'file-text','file-text-o'=>'file-text-o','file-video-o'=>'file-video-o','file-word-o'=>'file-word-o','file-zip-o'=>'file-zip-o','circle-o-notch'=>'circle-o-notch','cog'=>'cog','gear'=>'gear','refresh'=>'refresh','spinner'=>'spinner','check-square'=>'check-square','check-square-o'=>'check-square-o','circle'=>'circle','circle-o'=>'circle-o','dot-circle-o'=>'dot-circle-o','minus-square'=>'minus-square','minus-square-o'=>'minus-square-o','plus-square'=>'plus-square','plus-square-o'=>'plus-square-o','square'=>'square','square-o'=>'square-o','bitcoin'=>'bitcoin','btc'=>'btc','cny'=>'cny','dollar'=>'dollar','eur'=>'eur','euro'=>'euro','gbp'=>'gbp','inr'=>'inr','jpy'=>'jpy','krw'=>'krw','money'=>'money','rmb'=>'rmb','rouble'=>'rouble','rub'=>'rub','ruble'=>'ruble','rupee'=>'rupee','try'=>'try','turkish-lira'=>'turkish-lira','usd'=>'usd','won'=>'won','yen'=>'yen','align-center'=>'align-center','align-justify'=>'align-justify','align-left'=>'align-left','align-right'=>'align-right','bold'=>'bold','chain'=>'chain','chain-broken'=>'chain-broken','clipboard'=>'clipboard','columns'=>'columns','copy'=>'copy','cut'=>'cut','dedent'=>'dedent','eraser'=>'eraser','file'=>'file','file-o'=>'file-o','file-text'=>'file-text','file-text-o'=>'file-text-o','files-o'=>'files-o','floppy-o'=>'floppy-o','font'=>'font','header'=>'header','indent'=>'indent','italic'=>'italic','link'=>'link','list'=>'list','list-alt'=>'list-alt','list-ol'=>'list-ol','list-ul'=>'list-ul','outdent'=>'outdent','paperclip'=>'paperclip','paragraph'=>'paragraph','paste'=>'paste','repeat'=>'repeat','rotate-left'=>'rotate-left','rotate-right'=>'rotate-right','save'=>'save','scissors'=>'scissors','strikethrough'=>'strikethrough','subscript'=>'subscript','superscript'=>'superscript','table'=>'table','text-height'=>'text-height','text-width'=>'text-width','th'=>'th','th-large'=>'th-large','th-list'=>'th-list','underline'=>'underline','undo'=>'undo','unlink'=>'unlink','angle-double-down'=>'angle-double-down','angle-double-left'=>'angle-double-left','angle-double-right'=>'angle-double-right','angle-double-up'=>'angle-double-up','angle-down'=>'angle-down','angle-left'=>'angle-left','angle-right'=>'angle-right','angle-up'=>'angle-up','arrow-circle-down'=>'arrow-circle-down','arrow-circle-left'=>'arrow-circle-left','arrow-circle-o-down'=>'arrow-circle-o-down','arrow-circle-o-left'=>'arrow-circle-o-left','arrow-circle-o-right'=>'arrow-circle-o-right','arrow-circle-o-up'=>'arrow-circle-o-up','arrow-circle-right'=>'arrow-circle-right','arrow-circle-up'=>'arrow-circle-up','arrow-down'=>'arrow-down','arrow-left'=>'arrow-left','arrow-right'=>'arrow-right','arrow-up'=>'arrow-up','arrows'=>'arrows','arrows-alt'=>'arrows-alt','arrows-h'=>'arrows-h','arrows-v'=>'arrows-v','caret-down'=>'caret-down','caret-left'=>'caret-left','caret-right'=>'caret-right','caret-square-o-down'=>'caret-square-o-down','caret-square-o-left'=>'caret-square-o-left','caret-square-o-right'=>'caret-square-o-right','caret-square-o-up'=>'caret-square-o-up','caret-up'=>'caret-up','chevron-circle-down'=>'chevron-circle-down','chevron-circle-left'=>'chevron-circle-left','chevron-circle-right'=>'chevron-circle-right','chevron-circle-up'=>'chevron-circle-up','chevron-down'=>'chevron-down','chevron-left'=>'chevron-left','chevron-right'=>'chevron-right','chevron-up'=>'chevron-up','hand-o-down'=>'hand-o-down','hand-o-left'=>'hand-o-left','hand-o-right'=>'hand-o-right','hand-o-up'=>'hand-o-up','long-arrow-down'=>'long-arrow-down','long-arrow-left'=>'long-arrow-left','long-arrow-right'=>'long-arrow-right','long-arrow-up'=>'long-arrow-up','toggle-down'=>'toggle-down','toggle-left'=>'toggle-left','toggle-right'=>'toggle-right','toggle-up'=>'toggle-up','arrows-alt'=>'arrows-alt','backward'=>'backward','compress'=>'compress','eject'=>'eject','expand'=>'expand','fast-backward'=>'fast-backward','fast-forward'=>'fast-forward','forward'=>'forward','pause'=>'pause','play'=>'play','play-circle'=>'play-circle','play-circle-o'=>'play-circle-o','step-backward'=>'step-backward','step-forward'=>'step-forward','stop'=>'stop','youtube-play'=>'youtube-play','adn'=>'adn','android'=>'android','apple'=>'apple','behance'=>'behance','behance-square'=>'behance-square','bitbucket'=>'bitbucket','bitbucket-square'=>'bitbucket-square','bitcoin'=>'bitcoin','btc'=>'btc','codepen'=>'codepen','css3'=>'css3','delicious'=>'delicious','deviantart'=>'deviantart','digg'=>'digg','dribbble'=>'dribbble','dropbox'=>'dropbox','drupal'=>'drupal','empire'=>'empire','facebook'=>'facebook','facebook-square'=>'facebook-square','flickr'=>'flickr','foursquare'=>'foursquare','ge'=>'ge','git'=>'git','git-square'=>'git-square','github'=>'github','github-alt'=>'github-alt','github-square'=>'github-square','gittip'=>'gittip','google'=>'google','google-plus'=>'google-plus','google-plus-square'=>'google-plus-square','hacker-news'=>'hacker-news','html5'=>'html5','instagram'=>'instagram','joomla'=>'joomla','jsfiddle'=>'jsfiddle','linkedin'=>'linkedin','linkedin-square'=>'linkedin-square','linux'=>'linux','maxcdn'=>'maxcdn','openid'=>'openid','pagelines'=>'pagelines','pied-piper'=>'pied-piper','pied-piper-alt'=>'pied-piper-alt','pied-piper-square'=>'pied-piper-square','pinterest'=>'pinterest','pinterest-square'=>'pinterest-square','qq'=>'qq','ra'=>'ra','rebel'=>'rebel','reddit'=>'reddit','reddit-square'=>'reddit-square','renren'=>'renren','share-alt'=>'share-alt','share-alt-square'=>'share-alt-square','skype'=>'skype','slack'=>'slack','soundcloud'=>'soundcloud','spotify'=>'spotify','stack-exchange'=>'stack-exchange','stack-overflow'=>'stack-overflow','steam'=>'steam','steam-square'=>'steam-square','stumbleupon'=>'stumbleupon','stumbleupon-circle'=>'stumbleupon-circle','tencent-weibo'=>'tencent-weibo','trello'=>'trello','tumblr'=>'tumblr','tumblr-square'=>'tumblr-square','twitter'=>'twitter','twitter-square'=>'twitter-square','vimeo-square'=>'vimeo-square','vine'=>'vine','vk'=>'vk','wechat'=>'wechat','weibo'=>'weibo','weixin'=>'weixin','windows'=>'windows','wordpress'=>'wordpress','xing'=>'xing','xing-square'=>'xing-square','yahoo'=>'yahoo','youtube'=>'youtube','youtube-play'=>'youtube-play','youtube-square'=>'youtube-square','ambulance'=>'ambulance','h-square'=>'h-square','hospital-o'=>'hospital-o','medkit'=>'medkit','plus-square'=>'plus-square','stethoscope'=>'stethoscope','user-md'=>'user-md','wheelchair'=>'wheelchair','angellist'=>'angellist','area-chart'=>'fa-area-chart','at'=>'at','bell-slash'=>'bell-slash','bell-slash-o'=>'bell-slash-o','bicycle'=>'bicycle','binoculars'=>'binoculars','birthday-cake'=>'birthday-cake','bus'=>'bus','calculator'=>'calculator','cc'=>'cc','cc-amex'=>'cc-amex','cc-discover'=>'cc-discover','cc-paypal'=>'cc-paypal','cc-stripe'=>'cc-stripe','cc-visa'=>'cc-visa','copyright'=>'copyright','eyedropper'=>'eyedropper','futbol-o'=>'futbol-o','google-wallet'=>'google-wallet','ils'=>'ils','ioxhost'=>'ioxhost','lastfm'=>'lastfm','lastfm-square'=>'lastfm-square','line-chart'=>'line-chart','meanpath'=>'meanpath','newspaper-o'=>'newspaper-o','paint-brush'=>'paint-brush','paypal'=>'paypal','pie-chart'=>'pie-chart','plug'=>'plug','shekel'=>'shekel','sheqel'=>'sheqel','slideshare'=>'slideshare','soccer-ball-o'=>'soccer-ball-o','toggle-off'=>'toggle-off','toggle-on'=>'toggle-on','trash'=>'trash','tty'=>'tty','twitch'=>'twitch','wifi'=>'wifi','yelp'=>'yelp','bed'=>'bed','buysellads'=>'buysellads','cart-arrow-down'=>'cart-arrow-down','cart-plus'=>'cart-plus','connect develop'=>'connectdevelop','dash cube'=>'dashcube','diamond'=>'diamond','facebook-official'=>'facebook-official','forumbee'=>'forumbee','heartbeat'=>'heartbeat','hotel'=>'hotel','lean pub'=>'leanpub','mars'=>'mars','mars-double'=>'mars-double','mars-stroke'=>'mars-stroke','mars-stroke-h'=>'mars-stroke-h','mars-stroke-v'=>'mars-stroke-v','medium'=>'medium','mercury'=>'mercury','motorcycle'=>'motorcycle','neuter'=>'neuter','pinterest-p'=>'pinterest-p','sellsy'=>'sellsy','server'=>'server','ship'=>'ship','shirtsinbulk'=>'shirtsinbulk','simplybuilt'=>'simplybuilt','skyatlas'=>'skyatlas','street-view'=>'street-view','subway'=>'subway','train'=>'train','transgender'=>'transgender','transgender-alt'=>'transgender-alt','user-plus'=>'user-plus','user-secret'=>'user-secret','user-times'=>'user-times','venus'=>'venus','venus-double'=>'venus-double','venus-mars'=>'venus-mars','viacoin'=>'viacoin','whatsapp'=>'whatsapp',);
	return apply_filters( 'ttbase_framework_shortcodes_font_icons_array', $font_icons );
}
function ttbase_framework_shortcodes_streamline_font_icons_array() {
	$streamline_font_icons=array( esc_html__( 'None', 'ttbase-framework' ) => 'none', 'bin'=>'bin-1', 'flash'=>'flash-2', 'paperclip'=>'paperclip-1', 'email'=>'email-2','email-compose'=>'email-compose','reply'=>'reply','reply-all'=>'reply-all','account-group'=>'account-group-5','bubble-chat-add'=>'bubble-chat-add-1','bubble-chat-list'=>'bubble-chat-list-1','phone'=>'phone-3','phone-alt'=>'phone-5','phone-call'=>'phone-call-2','phone-call-24-hours'=>'phone-call-24-hours','mobile-phone-portrait'=>'mobile-phone-portrait','navigation-drawer'=>'navigation-drawer-2','new-document'=>'new-document','lock-close'=>'lock-close-1','lock-open'=>'lock-open-1','megaphone'=>'megaphone-1','report-problem-circle'=>'report-problem-circle','camera'=>'camera-2','video-camera'=>'video-camera-2','cd'=>'cd','basket'=>'basket-1','shopping-cart'=>'shopping-cart-4','window'=>'window-1','globe-question'=>'globe-question','location-pin'=>'location-pin-2','map-pin'=>'map-pin-1','building'=>'building-9','bird-cage'=>'bird-cage','pet-bone'=>'pet-bone','pet-box'=>'pet-box','pet-collar'=>'pet-collar-2','pet-litter-scoop'=>'pet-litter-scoop','pet-paw'=>'pet-paw','pet-yarn-ball'=>'pet-yarn-ball','heart-beat'=>'heart-beat','medicine-capsule'=>'medicine-capsule-1','file-add'=>'file-add-2','file-block'=>'file-block-2','file-edit'=>'file-edit-2','file-favorite-heart'=>'file-favorite-heart-2','folder'=>'folder-2','folder-document'=>'folder-document','arrow-box-down'=>'arrow-box-down-3','arrow-box-left'=>'arrow-box-left-3','arrow-box-right'=>'arrow-box-right-3','arrow-box-up'=>'arrow-box-up-3','arrow-left'=>'arrow-left-7','arrow-left-alt'=>'arrow-left-12','arrow-right'=>'arrow-right-7','arrow-right-alt'=>'arrow-right-12','digg'=>'digg','dribbble'=>'dribbble','facebook'=>'facebook','flickr'=>'flickr','google-drive'=>'google-drive','google-plus'=>'google-plus','google'=>'google','icq'=>'icq','instagram'=>'instagram','linkedin'=>'linkedin','magento'=>'magento','path'=>'path','paypal'=>'paypal','photobucket'=>'photobucket','pinterest'=>'pinterest','plurk'=>'plurk','reddit'=>'reddit','skype'=>'skype','tumblr'=>'tumblr','twitter-bird'=>'twitter-bird','twitter'=>'twitter','vimeo-square'=>'vimeo-square','virb'=>'virb','vk'=>'vk','wattpad'=>'wattpad','whatsapp'=>'whatsapp','xing'=>'xing','yahoo'=>'yahoo','yammer'=>'yammer','youtube'=>'youtube');
	return apply_filters( 'ttbase_framework_shortcodes_streamline_font_icons_array', $streamline_font_icons );
}

function ttbase_framework_shortcodes_iconsmind_font_icons_array() {
	$iconsmind_font_icons=array( esc_html__( 'None', 'ttbase-framework' ) => 'none','A-Z'=>'A-Z','Aa'=>'Aa','Add-Bag'=>'Add-Bag','Add-Basket'=>'Add-Basket','Add-Cart'=>'Add-Cart','Add-File'=>'Add-File','Add-SpaceAfterParagraph'=>'Add-SpaceAfterParagraph','Add-SpaceBeforeParagraph'=>'Add-SpaceBeforeParagraph','Add-User'=>'Add-User','Add-UserStar'=>'Add-UserStar','Add-Window'=>'Add-Window','Add'=>'Add','Address-Book'=>'Address-Book','Address-Book2'=>'Address-Book2','Administrator'=>'Administrator','Aerobics-2'=>'Aerobics-2','Aerobics-3'=>'Aerobics-3','Aerobics'=>'Aerobics','Affiliate'=>'Affiliate','Aim'=>'Aim','Air-Balloon'=>'Air-Balloon','Airbrush'=>'Airbrush','Airship'=>'Airship','Alarm-Clock'=>'Alarm-Clock','Alarm-Clock2'=>'Alarm-Clock2','Alarm'=>'Alarm','Alien-2'=>'Alien-2','Alien'=>'Alien','Aligator'=>'Aligator','Align-Center'=>'Align-Center','Align-JustifyAll'=>'Align-JustifyAll','Align-JustifyCenter'=>'Align-JustifyCenter','Align-JustifyLeft'=>'Align-JustifyLeft','Align-JustifyRight'=>'Align-JustifyRight','Align-Left'=>'Align-Left','Align-Right'=>'Align-Right','Alpha'=>'Alpha','Ambulance'=>'Ambulance','AMX'=>'AMX','Anchor-2'=>'Anchor-2','Anchor'=>'Anchor','Android-Store'=>'Android-Store','Android'=>'Android','Angel-Smiley'=>'Angel-Smiley','Angel'=>'Angel','Angry'=>'Angry','Apple-Bite'=>'Apple-Bite','Apple-Store'=>'Apple-Store','Apple'=>'Apple','Approved-Window'=>'Approved-Window','Aquarius-2'=>'Aquarius-2','Aquarius'=>'Aquarius','Archery-2'=>'Archery-2','Archery'=>'Archery','Argentina'=>'Argentina','Aries-2'=>'Aries-2','Aries'=>'Aries','Army-Key'=>'Army-Key','Arrow-Around'=>'Arrow-Around','Arrow-Back3'=>'Arrow-Back3','Arrow-Back'=>'Arrow-Back','Arrow-Back2'=>'Arrow-Back2','Arrow-Barrier'=>'Arrow-Barrier','Arrow-Circle'=>'Arrow-Circle','Arrow-Cross'=>'Arrow-Cross','Arrow-Down'=>'Arrow-Down','Arrow-Down2'=>'Arrow-Down2','Arrow-Down3'=>'Arrow-Down3','Arrow-DowninCircle'=>'Arrow-DowninCircle','Arrow-Fork'=>'Arrow-Fork','Arrow-Forward'=>'Arrow-Forward','Arrow-Forward2'=>'Arrow-Forward2','Arrow-From'=>'Arrow-From','Arrow-Inside'=>'Arrow-Inside','Arrow-Inside45'=>'Arrow-Inside45','Arrow-InsideGap'=>'Arrow-InsideGap','Arrow-InsideGap45'=>'Arrow-InsideGap45','Arrow-Into'=>'Arrow-Into','Arrow-Join'=>'Arrow-Join','Arrow-Junction'=>'Arrow-Junction','Arrow-Left'=>'Arrow-Left','Arrow-Left2'=>'Arrow-Left2','Arrow-LeftinCircle'=>'Arrow-LeftinCircle','Arrow-Loop'=>'Arrow-Loop','Arrow-Merge'=>'Arrow-Merge','Arrow-Mix'=>'Arrow-Mix','Arrow-Next'=>'Arrow-Next','Arrow-OutLeft'=>'Arrow-OutLeft','Arrow-OutRight'=>'Arrow-OutRight','Arrow-Outside'=>'Arrow-Outside','Arrow-Outside45'=>'Arrow-Outside45','Arrow-OutsideGap'=>'Arrow-OutsideGap','Arrow-OutsideGap45'=>'Arrow-OutsideGap45','Arrow-Over'=>'Arrow-Over','Arrow-Refresh'=>'Arrow-Refresh','Arrow-Refresh2'=>'Arrow-Refresh2','Arrow-Right'=>'Arrow-Right','Arrow-Right2'=>'Arrow-Right2','Arrow-RightinCircle'=>'Arrow-RightinCircle','Arrow-Shuffle'=>'Arrow-Shuffle','Arrow-Squiggly'=>'Arrow-Squiggly','Arrow-Through'=>'Arrow-Through','Arrow-To'=>'Arrow-To','Arrow-TurnLeft'=>'Arrow-TurnLeft','Arrow-TurnRight'=>'Arrow-TurnRight','Arrow-Up'=>'Arrow-Up','Arrow-Up2'=>'Arrow-Up2','Arrow-Up3'=>'Arrow-Up3','Arrow-UpinCircle'=>'Arrow-UpinCircle','Arrow-XLeft'=>'Arrow-XLeft','Arrow-XRight'=>'Arrow-XRight','Ask'=>'Ask','Assistant'=>'Assistant','Astronaut'=>'Astronaut','At-Sign'=>'At-Sign','ATM'=>'ATM','Atom'=>'Atom','Audio'=>'Audio','Auto-Flash'=>'Auto-Flash','Autumn'=>'Autumn','Baby-Clothes'=>'Baby-Clothes','Baby-Clothes2'=>'Baby-Clothes2','Baby-Cry'=>'Baby-Cry','Baby'=>'Baby','Back2'=>'Back2','Back-Media'=>'Back-Media','Back-Music'=>'Back-Music','Back'=>'Back','Background'=>'Background','Bacteria'=>'Bacteria','Bag-Coins'=>'Bag-Coins','Bag-Items'=>'Bag-Items','Bag-Quantity'=>'Bag-Quantity','Bag'=>'Bag','Bakelite'=>'Bakelite','Ballet-Shoes'=>'Ballet-Shoes','Balloon'=>'Balloon','Banana'=>'Banana','Band-Aid'=>'Band-Aid','Bank'=>'Bank','Bar-Chart'=>'Bar-Chart','Bar-Chart2'=>'Bar-Chart2','Bar-Chart3'=>'Bar-Chart3','Bar-Chart4'=>'Bar-Chart4','Bar-Chart5'=>'Bar-Chart5','Bar-Code'=>'Bar-Code','Barricade-2'=>'Barricade-2','Barricade'=>'Barricade','Baseball'=>'Baseball','Basket-Ball'=>'Basket-Ball','Basket-Coins'=>'Basket-Coins','Basket-Items'=>'Basket-Items','Basket-Quantity'=>'Basket-Quantity','Bat-2'=>'Bat-2','Bat'=>'Bat','Bathrobe'=>'Bathrobe','Batman-Mask'=>'Batman-Mask','Battery-0'=>'Battery-0','Battery-25'=>'Battery-25','Battery-50'=>'Battery-50','Battery-75'=>'Battery-75','Battery-100'=>'Battery-100','Battery-Charge'=>'Battery-Charge','Bear'=>'Bear','Beard-2'=>'Beard-2','Beard-3'=>'Beard-3','Beard'=>'Beard','Bebo'=>'Bebo','Bee'=>'Bee','Beer-Glass'=>'Beer-Glass','Beer'=>'Beer','Bell-2'=>'Bell-2','Bell'=>'Bell','Belt-2'=>'Belt-2','Belt-3'=>'Belt-3','Belt'=>'Belt','Berlin-Tower'=>'Berlin-Tower','Beta'=>'Beta','Betvibes'=>'Betvibes','Bicycle-2'=>'Bicycle-2','Bicycle-3'=>'Bicycle-3','Bicycle'=>'Bicycle','Big-Bang'=>'Big-Bang','Big-Data'=>'Big-Data','Bike-Helmet'=>'Bike-Helmet','Bikini'=>'Bikini','Bilk-Bottle2'=>'Bilk-Bottle2','Billing'=>'Billing','Bing'=>'Bing','Binocular'=>'Binocular','Bio-Hazard'=>'Bio-Hazard','Biotech'=>'Biotech','Bird-DeliveringLetter'=>'Bird-DeliveringLetter','Bird'=>'Bird','Birthday-Cake'=>'Birthday-Cake','Bisexual'=>'Bisexual','Bishop'=>'Bishop','Bitcoin'=>'Bitcoin','Black-Cat'=>'Black-Cat','Blackboard'=>'Blackboard','Blinklist'=>'Blinklist','Block-Cloud'=>'Block-Cloud','Block-Window'=>'Block-Window','Blogger'=>'Blogger','Blood'=>'Blood','Blouse'=>'Blouse','Blueprint'=>'Blueprint','Board'=>'Board','Bodybuilding'=>'Bodybuilding','Bold-Text'=>'Bold-Text','Bone'=>'Bone','Bones'=>'Bones','Book'=>'Book','Bookmark'=>'Bookmark','Books-2'=>'Books-2','Books'=>'Books','Boom'=>'Boom','Boot-2'=>'Boot-2','Boot'=>'Boot','Bottom-ToTop'=>'Bottom-ToTop','Bow-2'=>'Bow-2','Bow-3'=>'Bow-3','Bow-4'=>'Bow-4','Bow-5'=>'Bow-5','Bow-6'=>'Bow-6','Bow'=>'Bow','Bowling-2'=>'Bowling-2','Bowling'=>'Bowling','Box2'=>'Box2','Box-Close'=>'Box-Close','Box-Full'=>'Box-Full','Box-Open'=>'Box-Open','Box-withFolders'=>'Box-withFolders','Box'=>'Box','Boy'=>'Boy','Bra'=>'Bra','Brain-2'=>'Brain-2','Brain-3'=>'Brain-3','Brain'=>'Brain','Brazil'=>'Brazil','Bread-2'=>'Bread-2','Bread'=>'Bread','Bridge'=>'Bridge','Brightkite'=>'Brightkite','Broke-Link2'=>'Broke-Link2','Broken-Link'=>'Broken-Link','Broom'=>'Broom','Brush'=>'Brush','Bucket'=>'Bucket','Bug'=>'Bug','Building'=>'Building','Bulleted-List'=>'Bulleted-List','Bus-2'=>'Bus-2','Bus'=>'Bus','Business-Man'=>'Business-Man','Business-ManWoman'=>'Business-ManWoman','Business-Mens'=>'Business-Mens','Business-Woman'=>'Business-Woman','Butterfly'=>'Butterfly','Button'=>'Button','Cable-Car'=>'Cable-Car','Cake'=>'Cake','Calculator-2'=>'Calculator-2','Calculator-3'=>'Calculator-3','Calculator'=>'Calculator','Calendar-2'=>'Calendar-2','Calendar-3'=>'Calendar-3','Calendar-4'=>'Calendar-4','Calendar-Clock'=>'Calendar-Clock','Calendar'=>'Calendar','Camel'=>'Camel','Camera-2'=>'Camera-2','Camera-3'=>'Camera-3','Camera-4'=>'Camera-4','Camera-5'=>'Camera-5','Camera-Back'=>'Camera-Back','Camera'=>'Camera','Can-2'=>'Can-2','Can'=>'Can','Canada'=>'Canada','Cancer-2'=>'Cancer-2','Cancer-3'=>'Cancer-3','Cancer'=>'Cancer','Candle'=>'Candle','Candy-Cane'=>'Candy-Cane','Candy'=>'Candy','Cannon'=>'Cannon','Cap-2'=>'Cap-2','Cap-3'=>'Cap-3','Cap-Smiley'=>'Cap-Smiley','Cap'=>'Cap','Capricorn-2'=>'Capricorn-2','Capricorn'=>'Capricorn','Car-2'=>'Car-2','Car-3'=>'Car-3','Car-Coins'=>'Car-Coins','Car-Items'=>'Car-Items','Car-Wheel'=>'Car-Wheel','Car'=>'Car','Cardigan'=>'Cardigan','Cardiovascular'=>'Cardiovascular','Cart-Quantity'=>'Cart-Quantity','Casette-Tape'=>'Casette-Tape','Cash-Register'=>'Cash-Register','Cash-register2'=>'Cash-register2','Castle'=>'Castle','Cat'=>'Cat','Cathedral'=>'Cathedral','Cauldron'=>'Cauldron','CD-2'=>'CD-2','CD-Cover'=>'CD-Cover','CD'=>'CD','Cello'=>'Cello','Celsius'=>'Celsius','Chacked-Flag'=>'Chacked-Flag','Chair'=>'Chair','Charger'=>'Charger','Check-2'=>'Check-2','Check'=>'Check','Checked-User'=>'Checked-User','Checkmate'=>'Checkmate','Checkout-Bag'=>'Checkout-Bag','Checkout-Basket'=>'Checkout-Basket','Checkout'=>'Checkout','Cheese'=>'Cheese','Cheetah'=>'Cheetah','Chef-Hat'=>'Chef-Hat','Chef-Hat2'=>'Chef-Hat2','Chef'=>'Chef','Chemical-2'=>'Chemical-2','Chemical-3'=>'Chemical-3','Chemical-4'=>'Chemical-4','Chemical-5'=>'Chemical-5','Chemical'=>'Chemical','Chess-Board'=>'Chess-Board','Chess'=>'Chess','Chicken'=>'Chicken','Chile'=>'Chile','Chimney'=>'Chimney','China'=>'China','Chinese-Temple'=>'Chinese-Temple','Chip'=>'Chip','Chopsticks-2'=>'Chopsticks-2','Chopsticks'=>'Chopsticks','Christmas-Ball'=>'Christmas-Ball','Christmas-Bell'=>'Christmas-Bell','Christmas-Candle'=>'Christmas-Candle','Christmas-Hat'=>'Christmas-Hat','Christmas-Sleigh'=>'Christmas-Sleigh','Christmas-Snowman'=>'Christmas-Snowman','Christmas-Sock'=>'Christmas-Sock','Christmas-Tree'=>'Christmas-Tree','Christmas'=>'Christmas','Chrome'=>'Chrome','Chrysler-Building'=>'Chrysler-Building','Cinema'=>'Cinema','Circular-Point'=>'Circular-Point','City-Hall'=>'City-Hall','Clamp'=>'Clamp','Clapperboard-Close'=>'Clapperboard-Close','Clapperboard-Open'=>'Clapperboard-Open','Claps'=>'Claps','Clef'=>'Clef','Clinic'=>'Clinic','Clock-2'=>'Clock-2','Clock-3'=>'Clock-3','Clock-4'=>'Clock-4','Clock-Back'=>'Clock-Back','Clock-Forward'=>'Clock-Forward','Clock'=>'Clock','Close-Window'=>'Close-Window','Close'=>'Close','Clothing-Store'=>'Clothing-Store','Cloud--'=>'Cloud--','Cloud-'=>'Cloud-','Cloud-Camera'=>'Cloud-Camera','Cloud-Computer'=>'Cloud-Computer','Cloud-Email'=>'Cloud-Email','Cloud-Hail'=>'Cloud-Hail','Cloud-Laptop'=>'Cloud-Laptop','Cloud-Lock'=>'Cloud-Lock','Cloud-Moon'=>'Cloud-Moon','Cloud-Music'=>'Cloud-Music','Cloud-Picture'=>'Cloud-Picture','Cloud-Rain'=>'Cloud-Rain','Cloud-Remove'=>'Cloud-Remove','Cloud-Secure'=>'Cloud-Secure','Cloud-Settings'=>'Cloud-Settings','Cloud-Smartphone'=>'Cloud-Smartphone','Cloud-Snow'=>'Cloud-Snow','Cloud-Sun'=>'Cloud-Sun','Cloud-Tablet'=>'Cloud-Tablet','Cloud-Video'=>'Cloud-Video','Cloud-Weather'=>'Cloud-Weather','Cloud'=>'Cloud','Clouds-Weather'=>'Clouds-Weather','Clouds'=>'Clouds','Clown'=>'Clown','CMYK'=>'CMYK','Coat'=>'Coat','Cocktail'=>'Cocktail','Coconut'=>'Coconut','Code-Window'=>'Code-Window','Coding'=>'Coding','Coffee-2'=>'Coffee-2','Coffee-Bean'=>'Coffee-Bean','Coffee-Machine'=>'Coffee-Machine','Coffee-toGo'=>'Coffee-toGo','Coffee'=>'Coffee','Coffin'=>'Coffin','Coin'=>'Coin','Coins-2'=>'Coins-2','Coins-3'=>'Coins-3','Coins'=>'Coins','Colombia'=>'Colombia','Colosseum'=>'Colosseum','Column-2'=>'Column-2','Column-3'=>'Column-3','Column'=>'Column','Comb-2'=>'Comb-2','Comb'=>'Comb','Communication-Tower'=>'Communication-Tower','Communication-Tower2'=>'Communication-Tower2','Compass-2'=>'Compass-2','Compass-3'=>'Compass-3','Compass-4'=>'Compass-4','Compass-Rose'=>'Compass-Rose','Compass'=>'Compass','Computer-2'=>'Computer-2','Computer-3'=>'Computer-3','Computer-Secure'=>'Computer-Secure','Computer'=>'Computer','Conference'=>'Conference','Confused'=>'Confused','Conservation'=>'Conservation','Consulting'=>'Consulting','Contrast'=>'Contrast','Control-2'=>'Control-2','Control'=>'Control','Cookie-Man'=>'Cookie-Man','Cookies'=>'Cookies','Cool-Guy'=>'Cool-Guy','Cool'=>'Cool','Copyright'=>'Copyright','Costume'=>'Costume','Couple-Sign'=>'Couple-Sign','Cow'=>'Cow','CPU'=>'CPU','Crane'=>'Crane','Cranium'=>'Cranium','Credit-Card'=>'Credit-Card','Credit-Card2'=>'Credit-Card2','Credit-Card3'=>'Credit-Card3','Cricket'=>'Cricket','Criminal'=>'Criminal','Croissant'=>'Croissant','Crop-2'=>'Crop-2','Crop-3'=>'Crop-3','Crown-2'=>'Crown-2','Crown'=>'Crown','Crying'=>'Crying','Cube-Molecule'=>'Cube-Molecule','Cube-Molecule2'=>'Cube-Molecule2','Cupcake'=>'Cupcake','Cursor-Click'=>'Cursor-Click','Cursor-Click2'=>'Cursor-Click2','Cursor-Move'=>'Cursor-Move','Cursor-Move2'=>'Cursor-Move2','Cursor-Select'=>'Cursor-Select','Cursor'=>'Cursor','D-Eyeglasses'=>'D-Eyeglasses','D-Eyeglasses2'=>'D-Eyeglasses2','Dam'=>'Dam','Danemark'=>'Danemark','Danger-2'=>'Danger-2','Danger'=>'Danger','Dashboard'=>'Dashboard','Data-Backup'=>'Data-Backup','Data-Block'=>'Data-Block','Data-Center'=>'Data-Center','Data-Clock'=>'Data-Clock','Data-Cloud'=>'Data-Cloud','Data-Compress'=>'Data-Compress','Data-Copy'=>'Data-Copy','Data-Download'=>'Data-Download','Data-Financial'=>'Data-Financial','Data-Key'=>'Data-Key','Data-Lock'=>'Data-Lock','Data-Network'=>'Data-Network','Data-Password'=>'Data-Password','Data-Power'=>'Data-Power','Data-Refresh'=>'Data-Refresh','Data-Save'=>'Data-Save','Data-Search'=>'Data-Search','Data-Security'=>'Data-Security','Data-Settings'=>'Data-Settings','Data-Sharing'=>'Data-Sharing','Data-Shield'=>'Data-Shield','Data-Signal'=>'Data-Signal','Data-Storage'=>'Data-Storage','Data-Stream'=>'Data-Stream','Data-Transfer'=>'Data-Transfer','Data-Unlock'=>'Data-Unlock','Data-Upload'=>'Data-Upload','Data-Yes'=>'Data-Yes','Data'=>'Data','David-Star'=>'David-Star','Daylight'=>'Daylight','Death'=>'Death','Debian'=>'Debian','Dec'=>'Dec','Decrase-Inedit'=>'Decrase-Inedit','Deer-2'=>'Deer-2','Deer'=>'Deer','Delete-File'=>'Delete-File','Delete-Window'=>'Delete-Window','Delicious'=>'Delicious','Depression'=>'Depression','Deviantart'=>'Deviantart','Device-SyncwithCloud'=>'Device-SyncwithCloud','Diamond'=>'Diamond','Dice-2'=>'Dice-2','Dice'=>'Dice','Digg'=>'Digg','Digital-Drawing'=>'Digital-Drawing','Diigo'=>'Diigo','Dinosaur'=>'Dinosaur','Diploma-2'=>'Diploma-2','Diploma'=>'Diploma','Direction-East'=>'Direction-East','Direction-North'=>'Direction-North','Direction-South'=>'Direction-South','Direction-West'=>'Direction-West','Director'=>'Director','Disk'=>'Disk','Dj'=>'Dj','DNA-2'=>'DNA-2','DNA-Helix'=>'DNA-Helix','DNA'=>'DNA','Doctor'=>'Doctor','Dog'=>'Dog','Dollar-Sign'=>'Dollar-Sign','Dollar-Sign2'=>'Dollar-Sign2','Dollar'=>'Dollar','Dolphin'=>'Dolphin','Domino'=>'Domino','Door-Hanger'=>'Door-Hanger','Door'=>'Door','Doplr'=>'Doplr','Double-Circle'=>'Double-Circle','Double-Tap'=>'Double-Tap','Doughnut'=>'Doughnut','Dove'=>'Dove','Down-2'=>'Down-2','Down-3'=>'Down-3','Down-4'=>'Down-4','Down'=>'Down','Download-2'=>'Download-2','Download-fromCloud'=>'Download-fromCloud','Download-Window'=>'Download-Window','Download'=>'Download','Downward'=>'Downward','Drag-Down'=>'Drag-Down','Drag-Left'=>'Drag-Left','Drag-Right'=>'Drag-Right','Drag-Up'=>'Drag-Up','Drag'=>'Drag','Dress'=>'Dress','Drill-2'=>'Drill-2','Drill'=>'Drill','Drop'=>'Drop','Dropbox'=>'Dropbox','Drum'=>'Drum','Dry'=>'Dry','Duck'=>'Duck','Dumbbell'=>'Dumbbell','Duplicate-Layer'=>'Duplicate-Layer','Duplicate-Window'=>'Duplicate-Window','DVD'=>'DVD','Eagle'=>'Eagle','Ear'=>'Ear','Earphones-2'=>'Earphones-2','Earphones'=>'Earphones','Eci-im'=>'Eci-im','Edit-Map'=>'Edit-Map','Edit'=>'Edit','Eggs'=>'Eggs','Egypt'=>'Egypt','Eifel-Tower'=>'Eifel-Tower','eject-2'=>'eject-2','Eject'=>'Eject','El-Castillo'=>'El-Castillo','Elbow'=>'Elbow','Electric-Guitar'=>'Electric-Guitar','Electricity'=>'Electricity','Elephant'=>'Elephant','Email'=>'Email','Embassy'=>'Embassy','Empire-StateBuilding'=>'Empire-StateBuilding','Empty-Box'=>'Empty-Box','End2'=>'End2','End-2'=>'End-2','End'=>'End','Endways'=>'Endways','Engineering'=>'Engineering','Envelope-2'=>'Envelope-2','Envelope'=>'Envelope','Environmental-2'=>'Environmental-2','Environmental-3'=>'Environmental-3','Environmental'=>'Environmental','Equalizer'=>'Equalizer','Eraser-2'=>'Eraser-2','Eraser-3'=>'Eraser-3','Eraser'=>'Eraser','Error-404Window'=>'Error-404Window','Euro-Sign'=>'Euro-Sign','Euro-Sign2'=>'Euro-Sign2','Euro'=>'Euro','Evernote'=>'Evernote','Evil'=>'Evil','Explode'=>'Explode','Eye-2'=>'Eye-2','Eye-Blind'=>'Eye-Blind','Eye-Invisible'=>'Eye-Invisible','Eye-Scan'=>'Eye-Scan','Eye-Visible'=>'Eye-Visible','Eye'=>'Eye','Eyebrow-2'=>'Eyebrow-2','Eyebrow-3'=>'Eyebrow-3','Eyebrow'=>'Eyebrow','Eyeglasses-Smiley'=>'Eyeglasses-Smiley','Eyeglasses-Smiley2'=>'Eyeglasses-Smiley2','Face-Style'=>'Face-Style','Face-Style2'=>'Face-Style2','Face-Style3'=>'Face-Style3','Face-Style4'=>'Face-Style4','Face-Style5'=>'Face-Style5','Face-Style6'=>'Face-Style6','Facebook-2'=>'Facebook-2','Facebook'=>'Facebook','Factory-2'=>'Factory-2','Factory'=>'Factory','Fahrenheit'=>'Fahrenheit','Family-Sign'=>'Family-Sign','Fan'=>'Fan','Farmer'=>'Farmer','Fashion'=>'Fashion','Favorite-Window'=>'Favorite-Window','Fax'=>'Fax','Feather'=>'Feather','Feedburner'=>'Feedburner','Female-2'=>'Female-2','Female-Sign'=>'Female-Sign','Female'=>'Female','File-Block'=>'File-Block','File-Bookmark'=>'File-Bookmark','File-Chart'=>'File-Chart','File-Clipboard'=>'File-Clipboard','File-ClipboardFileText'=>'File-ClipboardFileText','File-ClipboardTextImage'=>'File-ClipboardTextImage','File-Cloud'=>'File-Cloud','File-Copy'=>'File-Copy','File-Copy2'=>'File-Copy2','File-CSV'=>'File-CSV','File-Download'=>'File-Download','File-Edit'=>'File-Edit','File-Excel'=>'File-Excel','File-Favorite'=>'File-Favorite','File-Fire'=>'File-Fire','File-Graph'=>'File-Graph','File-Hide'=>'File-Hide','File-Horizontal'=>'File-Horizontal','File-HorizontalText'=>'File-HorizontalText','File-HTML'=>'File-HTML','File-JPG'=>'File-JPG','File-Link'=>'File-Link','File-Loading'=>'File-Loading','File-Lock'=>'File-Lock','File-Love'=>'File-Love','File-Music'=>'File-Music','File-Network'=>'File-Network','File-Pictures'=>'File-Pictures','File-Pie'=>'File-Pie','File-Presentation'=>'File-Presentation','File-Refresh'=>'File-Refresh','File-Search'=>'File-Search','File-Settings'=>'File-Settings','File-Share'=>'File-Share','File-TextImage'=>'File-TextImage','File-Trash'=>'File-Trash','File-TXT'=>'File-TXT','File-Upload'=>'File-Upload','File-Video'=>'File-Video','File-Word'=>'File-Word','File-Zip'=>'File-Zip','File'=>'File','Files'=>'Files','Film-Board'=>'Film-Board','Film-Cartridge'=>'Film-Cartridge','Film-Strip'=>'Film-Strip','Film-Video'=>'Film-Video','Film'=>'Film','Filter-2'=>'Filter-2','Filter'=>'Filter','Financial'=>'Financial','Find-User'=>'Find-User','Finger-DragFourSides'=>'Finger-DragFourSides','Finger-DragTwoSides'=>'Finger-DragTwoSides','Finger-Print'=>'Finger-Print','Finger'=>'Finger','Fingerprint-2'=>'Fingerprint-2','Fingerprint'=>'Fingerprint','Fire-Flame'=>'Fire-Flame','Fire-Flame2'=>'Fire-Flame2','Fire-Hydrant'=>'Fire-Hydrant','Fire-Staion'=>'Fire-Staion','Firefox'=>'Firefox','Firewall'=>'Firewall','First-Aid'=>'First-Aid','First'=>'First','Fish-Food'=>'Fish-Food','Fish'=>'Fish','Fit-To'=>'Fit-To','Fit-To2'=>'Fit-To2','Five-Fingers'=>'Five-Fingers','Five-FingersDrag'=>'Five-FingersDrag','Five-FingersDrag2'=>'Five-FingersDrag2','Five-FingersTouch'=>'Five-FingersTouch','Flag-2'=>'Flag-2','Flag-3'=>'Flag-3','Flag-4'=>'Flag-4','Flag-5'=>'Flag-5','Flag-6'=>'Flag-6','Flag'=>'Flag','Flamingo'=>'Flamingo','Flash-2'=>'Flash-2','Flash-Video'=>'Flash-Video','Flash'=>'Flash','Flashlight'=>'Flashlight','Flask-2'=>'Flask-2','Flask'=>'Flask','Flick'=>'Flick','Flickr'=>'Flickr','Flowerpot'=>'Flowerpot','Fluorescent'=>'Fluorescent','Fog-Day'=>'Fog-Day','Fog-Night'=>'Fog-Night','Folder-Add'=>'Folder-Add','Folder-Archive'=>'Folder-Archive','Folder-Binder'=>'Folder-Binder','Folder-Binder2'=>'Folder-Binder2','Folder-Block'=>'Folder-Block','Folder-Bookmark'=>'Folder-Bookmark','Folder-Close'=>'Folder-Close','Folder-Cloud'=>'Folder-Cloud','Folder-Delete'=>'Folder-Delete','Folder-Download'=>'Folder-Download','Folder-Edit'=>'Folder-Edit','Folder-Favorite'=>'Folder-Favorite','Folder-Fire'=>'Folder-Fire','Folder-Hide'=>'Folder-Hide','Folder-Link'=>'Folder-Link','Folder-Loading'=>'Folder-Loading','Folder-Lock'=>'Folder-Lock','Folder-Love'=>'Folder-Love','Folder-Music'=>'Folder-Music','Folder-Network'=>'Folder-Network','Folder-Open'=>'Folder-Open','Folder-Open2'=>'Folder-Open2','Folder-Organizing'=>'Folder-Organizing','Folder-Pictures'=>'Folder-Pictures','Folder-Refresh'=>'Folder-Refresh','Folder-Remove-'=>'Folder-Remove-','Folder-Search'=>'Folder-Search','Folder-Settings'=>'Folder-Settings','Folder-Share'=>'Folder-Share','Folder-Trash'=>'Folder-Trash','Folder-Upload'=>'Folder-Upload','Folder-Video'=>'Folder-Video','Folder-WithDocument'=>'Folder-WithDocument','Folder-Zip'=>'Folder-Zip','Folder'=>'Folder','Folders'=>'Folders','Font-Color'=>'Font-Color','Font-Name'=>'Font-Name','Font-Size'=>'Font-Size','Font-Style'=>'Font-Style','Font-StyleSubscript'=>'Font-StyleSubscript','Font-StyleSuperscript'=>'Font-StyleSuperscript','Font-Window'=>'Font-Window','Foot-2'=>'Foot-2','Foot'=>'Foot','Football-2'=>'Football-2','Football'=>'Football','Footprint-2'=>'Footprint-2','Footprint-3'=>'Footprint-3','Footprint'=>'Footprint','Forest'=>'Forest','Fork'=>'Fork','Formspring'=>'Formspring','Formula'=>'Formula','Forsquare'=>'Forsquare','Forward'=>'Forward','Fountain-Pen'=>'Fountain-Pen','Four-Fingers'=>'Four-Fingers','Four-FingersDrag'=>'Four-FingersDrag','Four-FingersDrag2'=>'Four-FingersDrag2','Four-FingersTouch'=>'Four-FingersTouch','Fox'=>'Fox','Frankenstein'=>'Frankenstein','French-Fries'=>'French-Fries','Friendfeed'=>'Friendfeed','Friendster'=>'Friendster','Frog'=>'Frog','Fruits'=>'Fruits','Fuel'=>'Fuel','Full-Bag'=>'Full-Bag','Full-Basket'=>'Full-Basket','Full-Cart'=>'Full-Cart','Full-Moon'=>'Full-Moon','Full-Screen'=>'Full-Screen','Full-Screen2'=>'Full-Screen2','Full-View'=>'Full-View','Full-View2'=>'Full-View2','Full-ViewWindow'=>'Full-ViewWindow','Function'=>'Function','Funky'=>'Funky','Funny-Bicycle'=>'Funny-Bicycle','Furl'=>'Furl','Gamepad-2'=>'Gamepad-2','Gamepad'=>'Gamepad','Gas-Pump'=>'Gas-Pump','Gaugage-2'=>'Gaugage-2','Gaugage'=>'Gaugage','Gay'=>'Gay','Gear-2'=>'Gear-2','Gear'=>'Gear','Gears-2'=>'Gears-2','Gears'=>'Gears','Geek-2'=>'Geek-2','Geek'=>'Geek','Gemini-2'=>'Gemini-2','Gemini'=>'Gemini','Genius'=>'Genius','Gentleman'=>'Gentleman','Geo--'=>'Geo--','Geo-'=>'Geo-','Geo-Close'=>'Geo-Close','Geo-Love'=>'Geo-Love','Geo-Number'=>'Geo-Number','Geo-Star'=>'Geo-Star','Geo'=>'Geo','Geo2--'=>'Geo2--','Geo2-'=>'Geo2-','Geo2-Close'=>'Geo2-Close','Geo2-Love'=>'Geo2-Love','Geo2-Number'=>'Geo2-Number','Geo2-Star'=>'Geo2-Star','Geo2'=>'Geo2','Geo3--'=>'Geo3--','Geo3-'=>'Geo3-','Geo3-Close'=>'Geo3-Close','Geo3-Love'=>'Geo3-Love','Geo3-Number'=>'Geo3-Number','Geo3-Star'=>'Geo3-Star','Geo3'=>'Geo3','Gey'=>'Gey','Gift-Box'=>'Gift-Box','Giraffe'=>'Giraffe','Girl'=>'Girl','Glass-Water'=>'Glass-Water','Glasses-2'=>'Glasses-2','Glasses-3'=>'Glasses-3','Glasses'=>'Glasses','Global-Position'=>'Global-Position','Globe-2'=>'Globe-2','Globe'=>'Globe','Gloves'=>'Gloves','Go-Bottom'=>'Go-Bottom','Go-Top'=>'Go-Top','Goggles'=>'Goggles','Golf-2'=>'Golf-2','Golf'=>'Golf','Google-Buzz'=>'Google-Buzz','Google-Drive'=>'Google-Drive','Google-Play'=>'Google-Play','Google-Plus'=>'Google-Plus','Google'=>'Google','Gopro'=>'Gopro','Gorilla'=>'Gorilla','Gowalla'=>'Gowalla','Grave'=>'Grave','Graveyard'=>'Graveyard','Greece'=>'Greece','Green-Energy'=>'Green-Energy','Green-House'=>'Green-House','Guitar'=>'Guitar','Gun-2'=>'Gun-2','Gun-3'=>'Gun-3','Gun'=>'Gun','Gymnastics'=>'Gymnastics','Hair-2'=>'Hair-2','Hair-3'=>'Hair-3','Hair-4'=>'Hair-4','Hair'=>'Hair','Half-Moon'=>'Half-Moon','Halloween-HalfMoon'=>'Halloween-HalfMoon','Halloween-Moon'=>'Halloween-Moon','Hamburger'=>'Hamburger','Hammer'=>'Hammer','Hand-Touch'=>'Hand-Touch','Hand-Touch2'=>'Hand-Touch2','Hand-TouchSmartphone'=>'Hand-TouchSmartphone','Hand'=>'Hand','Hands'=>'Hands','Handshake'=>'Handshake','Hanger'=>'Hanger','Happy'=>'Happy','Hat-2'=>'Hat-2','Hat'=>'Hat','Haunted-House'=>'Haunted-House','HD-Video'=>'HD-Video','HD'=>'HD','HDD'=>'HDD','Headphone'=>'Headphone','Headphones'=>'Headphones','Headset'=>'Headset','Heart-2'=>'Heart-2','Heart'=>'Heart','Heels-2'=>'Heels-2','Heels'=>'Heels','Height-Window'=>'Height-Window','Helicopter-2'=>'Helicopter-2','Helicopter'=>'Helicopter','Helix-2'=>'Helix-2','Hello'=>'Hello','Helmet-2'=>'Helmet-2','Helmet-3'=>'Helmet-3','Helmet'=>'Helmet','Hipo'=>'Hipo','Hipster-Glasses'=>'Hipster-Glasses','Hipster-Glasses2'=>'Hipster-Glasses2','Hipster-Glasses3'=>'Hipster-Glasses3','Hipster-Headphones'=>'Hipster-Headphones','Hipster-Men'=>'Hipster-Men','Hipster-Men2'=>'Hipster-Men2','Hipster-Men3'=>'Hipster-Men3','Hipster-Sunglasses'=>'Hipster-Sunglasses','Hipster-Sunglasses2'=>'Hipster-Sunglasses2','Hipster-Sunglasses3'=>'Hipster-Sunglasses3','Hokey'=>'Hokey','Holly'=>'Holly','Home-2'=>'Home-2','Home-3'=>'Home-3','Home-4'=>'Home-4','Home-5'=>'Home-5','Home-Window'=>'Home-Window','Home'=>'Home','Homosexual'=>'Homosexual','Honey'=>'Honey','Hong-Kong'=>'Hong-Kong','Hoodie'=>'Hoodie','Horror'=>'Horror','Horse'=>'Horse','Hospital-2'=>'Hospital-2','Hospital'=>'Hospital','Host'=>'Host','Hot-Dog'=>'Hot-Dog','Hotel'=>'Hotel','Hour'=>'Hour','Hub'=>'Hub','Humor'=>'Humor','Hurt'=>'Hurt','Ice-Cream'=>'Ice-Cream','ICQ'=>'ICQ','ID-2'=>'ID-2','ID-3'=>'ID-3','ID-Card'=>'ID-Card','Idea-2'=>'Idea-2','Idea-3'=>'Idea-3','Idea-4'=>'Idea-4','Idea-5'=>'Idea-5','Idea'=>'Idea','Identification-Badge'=>'Identification-Badge','ImDB'=>'ImDB','Inbox-Empty'=>'Inbox-Empty','Inbox-Forward'=>'Inbox-Forward','Inbox-Full'=>'Inbox-Full','Inbox-Into'=>'Inbox-Into','Inbox-Out'=>'Inbox-Out','Inbox-Reply'=>'Inbox-Reply','Inbox'=>'Inbox','Increase-Inedit'=>'Increase-Inedit','Indent-FirstLine'=>'Indent-FirstLine','Indent-LeftMargin'=>'Indent-LeftMargin','Indent-RightMargin'=>'Indent-RightMargin','India'=>'India','Info-Window'=>'Info-Window','Information'=>'Information','Inifity'=>'Inifity','Instagram'=>'Instagram','Internet-2'=>'Internet-2','Internet-Explorer'=>'Internet-Explorer','Internet-Smiley'=>'Internet-Smiley','Internet'=>'Internet','iOS-Apple'=>'iOS-Apple','Israel'=>'Israel','Italic-Text'=>'Italic-Text','Jacket-2'=>'Jacket-2','Jacket'=>'Jacket','Jamaica'=>'Jamaica','Japan'=>'Japan','Japanese-Gate'=>'Japanese-Gate','Jeans'=>'Jeans','Jeep-2'=>'Jeep-2','Jeep'=>'Jeep','Jet'=>'Jet','Joystick'=>'Joystick','Juice'=>'Juice','Jump-Rope'=>'Jump-Rope','Kangoroo'=>'Kangoroo','Kenya'=>'Kenya','Key-2'=>'Key-2','Key-3'=>'Key-3','Key-Lock'=>'Key-Lock','Keyboard'=>'Keyboard','Keyboard3'=>'Keyboard3','Keypad'=>'Keypad','King-2'=>'King-2','King'=>'King','Kiss'=>'Kiss','Knee'=>'Knee','Knife-2'=>'Knife-2','Knife'=>'Knife','Knight'=>'Knight','Koala'=>'Koala','Korea'=>'Korea','Lamp'=>'Lamp','Landscape-2'=>'Landscape-2','Landscape'=>'Landscape','Lantern'=>'Lantern','Laptop-2'=>'Laptop-2','Laptop-3'=>'Laptop-3','Laptop-Phone'=>'Laptop-Phone','Laptop-Secure'=>'Laptop-Secure','Laptop-Tablet'=>'Laptop-Tablet','Laptop'=>'Laptop','Laser'=>'Laser','Last-FM'=>'Last-FM','Last'=>'Last','Laughing'=>'Laughing','Layer-1'=>'Layer-1','Layer-1'=>'Layer-1','Layer-Backward'=>'Layer-Backward','Layer-Forward'=>'Layer-Forward','Leafs-2'=>'Leafs-2','Leafs'=>'Leafs','Leaning-Tower'=>'Leaning-Tower','Left--Right'=>'Left--Right','Left--Right3'=>'Left--Right3','Left-2'=>'Left-2','Left-3'=>'Left-3','Left-4'=>'Left-4','Left-ToRight'=>'Left-ToRight','Left'=>'Left','Leg-2'=>'Leg-2','Leg'=>'Leg','Lego'=>'Lego','Lemon'=>'Lemon','Len-2'=>'Len-2','Len-3'=>'Len-3','Len'=>'Len','Leo-2'=>'Leo-2','Leo'=>'Leo','Leopard'=>'Leopard','Lesbian'=>'Lesbian','Lesbians'=>'Lesbians','Letter-Close'=>'Letter-Close','Letter-Open'=>'Letter-Open','Letter-Sent'=>'Letter-Sent','Libra-2'=>'Libra-2','Libra'=>'Libra','Library-2'=>'Library-2','Library'=>'Library','Life-Jacket'=>'Life-Jacket','Life-Safer'=>'Life-Safer','Light-Bulb'=>'Light-Bulb','Light-Bulb2'=>'Light-Bulb2','Light-BulbLeaf'=>'Light-BulbLeaf','Lighthouse'=>'Lighthouse','Like-2'=>'Like-2','Like'=>'Like','Line-Chart'=>'Line-Chart','Line-Chart2'=>'Line-Chart2','Line-Chart3'=>'Line-Chart3','Line-Chart4'=>'Line-Chart4','Line-Spacing'=>'Line-Spacing','Line-SpacingText'=>'Line-SpacingText','Link-2'=>'Link-2','Link'=>'Link','Linkedin-2'=>'Linkedin-2','Linkedin'=>'Linkedin','Linux'=>'Linux','Lion'=>'Lion','Livejournal'=>'Livejournal','Loading-2'=>'Loading-2','Loading-3'=>'Loading-3','Loading-Window'=>'Loading-Window','Loading'=>'Loading','Location-2'=>'Location-2','Location'=>'Location','Lock-2'=>'Lock-2','Lock-3'=>'Lock-3','Lock-User'=>'Lock-User','Lock-Window'=>'Lock-Window','Lock'=>'Lock','Lollipop-2'=>'Lollipop-2','Lollipop-3'=>'Lollipop-3','Lollipop'=>'Lollipop','Loop'=>'Loop','Loud'=>'Loud','Loudspeaker'=>'Loudspeaker','Love-2'=>'Love-2','Love-User'=>'Love-User','Love-Window'=>'Love-Window','Love'=>'Love','Lowercase-Text'=>'Lowercase-Text','Luggafe-Front'=>'Luggafe-Front','Luggage-2'=>'Luggage-2','Macro'=>'Macro','Magic-Wand'=>'Magic-Wand','Magnet'=>'Magnet','Magnifi-Glass-'=>'Magnifi-Glass-','Magnifi-Glass'=>'Magnifi-Glass','Magnifi-Glass2'=>'Magnifi-Glass2','Mail-2'=>'Mail-2','Mail-3'=>'Mail-3','Mail-Add'=>'Mail-Add','Mail-Attachement'=>'Mail-Attachement','Mail-Block'=>'Mail-Block','Mail-Delete'=>'Mail-Delete','Mail-Favorite'=>'Mail-Favorite','Mail-Forward'=>'Mail-Forward','Mail-Gallery'=>'Mail-Gallery','Mail-Inbox'=>'Mail-Inbox','Mail-Link'=>'Mail-Link','Mail-Lock'=>'Mail-Lock','Mail-Love'=>'Mail-Love','Mail-Money'=>'Mail-Money','Mail-Open'=>'Mail-Open','Mail-Outbox'=>'Mail-Outbox','Mail-Password'=>'Mail-Password','Mail-Photo'=>'Mail-Photo','Mail-Read'=>'Mail-Read','Mail-Removex'=>'Mail-Removex','Mail-Reply'=>'Mail-Reply','Mail-ReplyAll'=>'Mail-ReplyAll','Mail-Search'=>'Mail-Search','Mail-Send'=>'Mail-Send','Mail-Settings'=>'Mail-Settings','Mail-Unread'=>'Mail-Unread','Mail-Video'=>'Mail-Video','Mail-withAtSign'=>'Mail-withAtSign','Mail-WithCursors'=>'Mail-WithCursors','Mail'=>'Mail','Mailbox-Empty'=>'Mailbox-Empty','Mailbox-Full'=>'Mailbox-Full','Male-2'=>'Male-2','Male-Sign'=>'Male-Sign','Male'=>'Male','MaleFemale'=>'MaleFemale','Man-Sign'=>'Man-Sign','Management'=>'Management','Mans-Underwear'=>'Mans-Underwear','Mans-Underwear2'=>'Mans-Underwear2','Map-Marker'=>'Map-Marker','Map-Marker2'=>'Map-Marker2','Map-Marker3'=>'Map-Marker3','Map'=>'Map','Map2'=>'Map2','Marker-2'=>'Marker-2','Marker-3'=>'Marker-3','Marker'=>'Marker','Martini-Glass'=>'Martini-Glass','Mask'=>'Mask','Master-Card'=>'Master-Card','Maximize-Window'=>'Maximize-Window','Maximize'=>'Maximize','Medal-2'=>'Medal-2','Medal-3'=>'Medal-3','Medal'=>'Medal','Medical-Sign'=>'Medical-Sign','Medicine-2'=>'Medicine-2','Medicine-3'=>'Medicine-3','Medicine'=>'Medicine','Megaphone'=>'Megaphone','Memory-Card'=>'Memory-Card','Memory-Card2'=>'Memory-Card2','Memory-Card3'=>'Memory-Card3','Men'=>'Men','Menorah'=>'Menorah','Mens'=>'Mens','Metacafe'=>'Metacafe','Mexico'=>'Mexico','Mic'=>'Mic','Microphone-2'=>'Microphone-2','Microphone-3'=>'Microphone-3','Microphone-4'=>'Microphone-4','Microphone-5'=>'Microphone-5','Microphone-6'=>'Microphone-6','Microphone-7'=>'Microphone-7','Microphone'=>'Microphone','Microscope'=>'Microscope','Milk-Bottle'=>'Milk-Bottle','Mine'=>'Mine','Minimize-Maximize-Close-Windows'=>'Minimize-Maximize-Close-Windows','Minimize-Window'=>'Minimize-Window','Minimize'=>'Minimize','Mirror'=>'Mirror','Mixer'=>'Mixer','Mixx'=>'Mixx','Money-2'=>'Money-2','Money-Bag'=>'Money-Bag','Money-Smiley'=>'Money-Smiley','Money'=>'Money','Monitor-2'=>'Monitor-2','Monitor-3'=>'Monitor-3','Monitor-4'=>'Monitor-4','Monitor-5'=>'Monitor-5','Monitor-Analytics'=>'Monitor-Analytics','Monitor-Laptop'=>'Monitor-Laptop','Monitor-phone'=>'Monitor-phone','Monitor-Tablet'=>'Monitor-Tablet','Monitor-Vertical'=>'Monitor-Vertical','Monitor'=>'Monitor','Monitoring'=>'Monitoring','Monkey'=>'Monkey','Monster'=>'Monster','Morocco'=>'Morocco','Motorcycle'=>'Motorcycle','Mouse-2'=>'Mouse-2','Mouse-3'=>'Mouse-3','Mouse-4'=>'Mouse-4','Mouse-Pointer'=>'Mouse-Pointer','Mouse'=>'Mouse','Moustache-Smiley'=>'Moustache-Smiley','Movie-Ticket'=>'Movie-Ticket','Movie'=>'Movie','Mp3-File'=>'Mp3-File','Museum'=>'Museum','Mushroom'=>'Mushroom','Music-Note'=>'Music-Note','Music-Note2'=>'Music-Note2','Music-Note3'=>'Music-Note3','Music-Note4'=>'Music-Note4','Music-Player'=>'Music-Player','Mustache-2'=>'Mustache-2','Mustache-3'=>'Mustache-3','Mustache-4'=>'Mustache-4','Mustache-5'=>'Mustache-5','Mustache-6'=>'Mustache-6','Mustache-7'=>'Mustache-7','Mustache-8'=>'Mustache-8','Mustache'=>'Mustache','Mute'=>'Mute','Myspace'=>'Myspace','Navigat-Start'=>'Navigat-Start','Navigate-End'=>'Navigate-End','Navigation-LeftWindow'=>'Navigation-LeftWindow','Navigation-RightWindow'=>'Navigation-RightWindow','Nepal'=>'Nepal','Netscape'=>'Netscape','Network-Window'=>'Network-Window','Network'=>'Network','Neutron'=>'Neutron','New-Mail'=>'New-Mail','New-Tab'=>'New-Tab','Newspaper-2'=>'Newspaper-2','Newspaper'=>'Newspaper','Newsvine'=>'Newsvine','Next2'=>'Next2','Next-3'=>'Next-3','Next-Music'=>'Next-Music','Next'=>'Next','No-Battery'=>'No-Battery','No-Drop'=>'No-Drop','No-Flash'=>'No-Flash','No-Smoking'=>'No-Smoking','Noose'=>'Noose','Normal-Text'=>'Normal-Text','Note'=>'Note','Notepad-2'=>'Notepad-2','Notepad'=>'Notepad','Nuclear'=>'Nuclear','Numbering-List'=>'Numbering-List','Nurse'=>'Nurse','Office-Lamp'=>'Office-Lamp','Office'=>'Office','Oil'=>'Oil','Old-Camera'=>'Old-Camera','Old-Cassette'=>'Old-Cassette','Old-Clock'=>'Old-Clock','Old-Radio'=>'Old-Radio','Old-Sticky'=>'Old-Sticky','Old-Sticky2'=>'Old-Sticky2','Old-Telephone'=>'Old-Telephone','Old-TV'=>'Old-TV','On-Air'=>'On-Air','On-Off-2'=>'On-Off-2','On-Off-3'=>'On-Off-3','On-off'=>'On-off','One-Finger'=>'One-Finger','One-FingerTouch'=>'One-FingerTouch','One-Window'=>'One-Window','Open-Banana'=>'Open-Banana','Open-Book'=>'Open-Book','Opera-House'=>'Opera-House','Opera'=>'Opera','Optimization'=>'Optimization','Orientation-2'=>'Orientation-2','Orientation-3'=>'Orientation-3','Orientation'=>'Orientation','Orkut'=>'Orkut','Ornament'=>'Ornament','Over-Time'=>'Over-Time','Over-Time2'=>'Over-Time2','Owl'=>'Owl','Pac-Man'=>'Pac-Man','Paint-Brush'=>'Paint-Brush','Paint-Bucket'=>'Paint-Bucket','Paintbrush'=>'Paintbrush','Palette'=>'Palette','Palm-Tree'=>'Palm-Tree','Panda'=>'Panda','Panorama'=>'Panorama','Pantheon'=>'Pantheon','Pantone'=>'Pantone','Pants'=>'Pants','Paper-Plane'=>'Paper-Plane','Paper'=>'Paper','Parasailing'=>'Parasailing','Parrot'=>'Parrot','Password-2shopping'=>'Password-2shopping','Password-Field'=>'Password-Field','Password-shopping'=>'Password-shopping','Password'=>'Password','pause-2'=>'pause-2','Pause'=>'Pause','Paw'=>'Paw','Pawn'=>'Pawn','Paypal'=>'Paypal','Pen-2'=>'Pen-2','Pen-3'=>'Pen-3','Pen-4'=>'Pen-4','Pen-5'=>'Pen-5','Pen-6'=>'Pen-6','Pen'=>'Pen','Pencil-Ruler'=>'Pencil-Ruler','Pencil'=>'Pencil','Penguin'=>'Penguin','Pentagon'=>'Pentagon','People-onCloud'=>'People-onCloud','Pepper-withFire'=>'Pepper-withFire','Pepper'=>'Pepper','Petrol'=>'Petrol','Petronas-Tower'=>'Petronas-Tower','Philipines'=>'Philipines','Phone-2'=>'Phone-2','Phone-3'=>'Phone-3','Phone-3G'=>'Phone-3G','Phone-4G'=>'Phone-4G','Phone-Simcard'=>'Phone-Simcard','Phone-SMS'=>'Phone-SMS','Phone-Wifi'=>'Phone-Wifi','Phone'=>'Phone','Photo-2'=>'Photo-2','Photo-3'=>'Photo-3','Photo-Album'=>'Photo-Album','Photo-Album2'=>'Photo-Album2','Photo-Album3'=>'Photo-Album3','Photo'=>'Photo','Photos'=>'Photos','Physics'=>'Physics','Pi'=>'Pi','Piano'=>'Piano','Picasa'=>'Picasa','Pie-Chart'=>'Pie-Chart','Pie-Chart2'=>'Pie-Chart2','Pie-Chart3'=>'Pie-Chart3','Pilates-2'=>'Pilates-2','Pilates-3'=>'Pilates-3','Pilates'=>'Pilates','Pilot'=>'Pilot','Pinch'=>'Pinch','Ping-Pong'=>'Ping-Pong','Pinterest'=>'Pinterest','Pipe'=>'Pipe','Pipette'=>'Pipette','Piramids'=>'Piramids','Pisces-2'=>'Pisces-2','Pisces'=>'Pisces','Pizza-Slice'=>'Pizza-Slice','Pizza'=>'Pizza','Plane-2'=>'Plane-2','Plane'=>'Plane','Plant'=>'Plant','Plasmid'=>'Plasmid','Plaster'=>'Plaster','Plastic-CupPhone'=>'Plastic-CupPhone','Plastic-CupPhone2'=>'Plastic-CupPhone2','Plate'=>'Plate','Plates'=>'Plates','Plaxo'=>'Plaxo','Play-Music'=>'Play-Music','Plug-In'=>'Plug-In','Plug-In2'=>'Plug-In2','Plurk'=>'Plurk','Pointer'=>'Pointer','Poland'=>'Poland','Police-Man'=>'Police-Man','Police-Station'=>'Police-Station','Police-Woman'=>'Police-Woman','Police'=>'Police','Polo-Shirt'=>'Polo-Shirt','Portrait'=>'Portrait','Portugal'=>'Portugal','Post-Mail'=>'Post-Mail','Post-Mail2'=>'Post-Mail2','Post-Office'=>'Post-Office','Post-Sign'=>'Post-Sign','Post-Sign2ways'=>'Post-Sign2ways','Posterous'=>'Posterous','Pound-Sign'=>'Pound-Sign','Pound-Sign2'=>'Pound-Sign2','Pound'=>'Pound','Power-2'=>'Power-2','Power-3'=>'Power-3','Power-Cable'=>'Power-Cable','Power-Station'=>'Power-Station','Power'=>'Power','Prater'=>'Prater','Present'=>'Present','Presents'=>'Presents','Press'=>'Press','Preview'=>'Preview','Previous'=>'Previous','Pricing'=>'Pricing','Printer'=>'Printer','Professor'=>'Professor','Profile'=>'Profile','Project'=>'Project','Projector-2'=>'Projector-2','Projector'=>'Projector','Pulse'=>'Pulse','Pumpkin'=>'Pumpkin','Punk'=>'Punk','Punker'=>'Punker','Puzzle'=>'Puzzle','QIK'=>'QIK','QR-Code'=>'QR-Code','Queen-2'=>'Queen-2','Queen'=>'Queen','Quill-2'=>'Quill-2','Quill-3'=>'Quill-3','Quill'=>'Quill','Quotes-2'=>'Quotes-2','Quotes'=>'Quotes','Radio'=>'Radio','Radioactive'=>'Radioactive','Rafting'=>'Rafting','Rain-Drop'=>'Rain-Drop','Rainbow-2'=>'Rainbow-2','Rainbow'=>'Rainbow','Ram'=>'Ram','Razzor-Blade'=>'Razzor-Blade','Receipt-2'=>'Receipt-2','Receipt-3'=>'Receipt-3','Receipt-4'=>'Receipt-4','Receipt'=>'Receipt','Record2'=>'Record2','Record-3'=>'Record-3','Record-Music'=>'Record-Music','Record'=>'Record','Recycling-2'=>'Recycling-2','Recycling'=>'Recycling','Reddit'=>'Reddit','Redhat'=>'Redhat','Redirect'=>'Redirect','Redo'=>'Redo','Reel'=>'Reel','Refinery'=>'Refinery','Refresh-Window'=>'Refresh-Window','Refresh'=>'Refresh','Reload-2'=>'Reload-2','Reload-3'=>'Reload-3','Reload'=>'Reload','Remote-Controll'=>'Remote-Controll','Remote-Controll2'=>'Remote-Controll2','Remove-Bag'=>'Remove-Bag','Remove-Basket'=>'Remove-Basket','Remove-Cart'=>'Remove-Cart','Remove-File'=>'Remove-File','Remove-User'=>'Remove-User','Remove-Window'=>'Remove-Window','Remove'=>'Remove','Rename'=>'Rename','Repair'=>'Repair','Repeat-2'=>'Repeat-2','Repeat-3'=>'Repeat-3','Repeat-4'=>'Repeat-4','Repeat-5'=>'Repeat-5','Repeat-6'=>'Repeat-6','Repeat-7'=>'Repeat-7','Repeat'=>'Repeat','Reset'=>'Reset','Resize'=>'Resize','Restore-Window'=>'Restore-Window','Retouching'=>'Retouching','Retro-Camera'=>'Retro-Camera','Retro'=>'Retro','Retweet'=>'Retweet','Reverbnation'=>'Reverbnation','Rewind'=>'Rewind','RGB'=>'RGB','Ribbon-2'=>'Ribbon-2','Ribbon-3'=>'Ribbon-3','Ribbon'=>'Ribbon','Right-2'=>'Right-2','Right-3'=>'Right-3','Right-4'=>'Right-4','Right-ToLeft'=>'Right-ToLeft','Right'=>'Right','Road-2'=>'Road-2','Road-3'=>'Road-3','Road'=>'Road','Robot-2'=>'Robot-2','Robot'=>'Robot','Rock-andRoll'=>'Rock-andRoll','Rocket'=>'Rocket','Roller'=>'Roller','Roof'=>'Roof','Rook'=>'Rook','Rotate-Gesture'=>'Rotate-Gesture','Rotate-Gesture2'=>'Rotate-Gesture2','Rotate-Gesture3'=>'Rotate-Gesture3','Rotation-390'=>'Rotation-390','Rotation'=>'Rotation','Router-2'=>'Router-2','Router'=>'Router','RSS'=>'RSS','Ruler-2'=>'Ruler-2','Ruler'=>'Ruler','Running-Shoes'=>'Running-Shoes','Running'=>'Running','Safari'=>'Safari','Safe-Box'=>'Safe-Box','Safe-Box2'=>'Safe-Box2','Safety-PinClose'=>'Safety-PinClose','Safety-PinOpen'=>'Safety-PinOpen','Sagittarus-2'=>'Sagittarus-2','Sagittarus'=>'Sagittarus','Sailing-Ship'=>'Sailing-Ship','Sand-watch'=>'Sand-watch','Sand-watch2'=>'Sand-watch2','Santa-Claus'=>'Santa-Claus','Santa-Claus2'=>'Santa-Claus2','Santa-onSled'=>'Santa-onSled','Satelite-2'=>'Satelite-2','Satelite'=>'Satelite','Save-Window'=>'Save-Window','Save'=>'Save','Saw'=>'Saw','Saxophone'=>'Saxophone','Scale'=>'Scale','Scarf'=>'Scarf','Scissor'=>'Scissor','Scooter-Front'=>'Scooter-Front','Scooter'=>'Scooter','Scorpio-2'=>'Scorpio-2','Scorpio'=>'Scorpio','Scotland'=>'Scotland','Screwdriver'=>'Screwdriver','Scroll-Fast'=>'Scroll-Fast','Scroll'=>'Scroll','Scroller-2'=>'Scroller-2','Scroller'=>'Scroller','Sea-Dog'=>'Sea-Dog','Search-onCloud'=>'Search-onCloud','Search-People'=>'Search-People','secound'=>'secound','secound2'=>'secound2','Security-Block'=>'Security-Block','Security-Bug'=>'Security-Bug','Security-Camera'=>'Security-Camera','Security-Check'=>'Security-Check','Security-Settings'=>'Security-Settings','Security-Smiley'=>'Security-Smiley','Securiy-Remove'=>'Securiy-Remove','Seed'=>'Seed','Selfie'=>'Selfie','Serbia'=>'Serbia','Server-2'=>'Server-2','Server'=>'Server','Servers'=>'Servers','Settings-Window'=>'Settings-Window','Sewing-Machine'=>'Sewing-Machine','Sexual'=>'Sexual','Share-onCloud'=>'Share-onCloud','Share-Window'=>'Share-Window','Share'=>'Share','Sharethis'=>'Sharethis','Shark'=>'Shark','Sheep'=>'Sheep','Sheriff-Badge'=>'Sheriff-Badge','Shield'=>'Shield','Ship-2'=>'Ship-2','Ship'=>'Ship','Shirt'=>'Shirt','Shoes-2'=>'Shoes-2','Shoes-3'=>'Shoes-3','Shoes'=>'Shoes','Shop-2'=>'Shop-2','Shop-3'=>'Shop-3','Shop-4'=>'Shop-4','Shop'=>'Shop','Shopping-Bag'=>'Shopping-Bag','Shopping-Basket'=>'Shopping-Basket','Shopping-Cart'=>'Shopping-Cart','Short-Pants'=>'Short-Pants','Shoutwire'=>'Shoutwire','Shovel'=>'Shovel','Shuffle-2'=>'Shuffle-2','Shuffle-3'=>'Shuffle-3','Shuffle-4'=>'Shuffle-4','Shuffle'=>'Shuffle','Shutter'=>'Shutter','Sidebar-Window'=>'Sidebar-Window','Signal'=>'Signal','Singapore'=>'Singapore','Skate-Shoes'=>'Skate-Shoes','Skateboard-2'=>'Skateboard-2','Skateboard'=>'Skateboard','Skeleton'=>'Skeleton','Ski'=>'Ski','Skirt'=>'Skirt','Skrill'=>'Skrill','Skull'=>'Skull','Skydiving'=>'Skydiving','Skype'=>'Skype','Sled-withGifts'=>'Sled-withGifts','Sled'=>'Sled','Sleeping'=>'Sleeping','Sleet'=>'Sleet','Slippers'=>'Slippers','Smart'=>'Smart','Smartphone-2'=>'Smartphone-2','Smartphone-3'=>'Smartphone-3','Smartphone-4'=>'Smartphone-4','Smartphone-Secure'=>'Smartphone-Secure','Smartphone'=>'Smartphone','Smile'=>'Smile','Smoking-Area'=>'Smoking-Area','Smoking-Pipe'=>'Smoking-Pipe','Snake'=>'Snake','Snorkel'=>'Snorkel','Snow-2'=>'Snow-2','Snow-Dome'=>'Snow-Dome','Snow-Storm'=>'Snow-Storm','Snow'=>'Snow','Snowflake-2'=>'Snowflake-2','Snowflake-3'=>'Snowflake-3','Snowflake-4'=>'Snowflake-4','Snowflake'=>'Snowflake','Snowman'=>'Snowman','Soccer-Ball'=>'Soccer-Ball','Soccer-Shoes'=>'Soccer-Shoes','Socks'=>'Socks','Solar'=>'Solar','Sound-Wave'=>'Sound-Wave','Sound'=>'Sound','Soundcloud'=>'Soundcloud','Soup'=>'Soup','South-Africa'=>'South-Africa','Space-Needle'=>'Space-Needle','Spain'=>'Spain','Spam-Mail'=>'Spam-Mail','Speach-Bubble'=>'Speach-Bubble','Speach-Bubble2'=>'Speach-Bubble2','Speach-Bubble3'=>'Speach-Bubble3','Speach-Bubble4'=>'Speach-Bubble4','Speach-Bubble5'=>'Speach-Bubble5','Speach-Bubble6'=>'Speach-Bubble6','Speach-Bubble7'=>'Speach-Bubble7','Speach-Bubble8'=>'Speach-Bubble8','Speach-Bubble9'=>'Speach-Bubble9','Speach-Bubble10'=>'Speach-Bubble10','Speach-Bubble11'=>'Speach-Bubble11','Speach-Bubble12'=>'Speach-Bubble12','Speach-Bubble13'=>'Speach-Bubble13','Speach-BubbleAsking'=>'Speach-BubbleAsking','Speach-BubbleComic'=>'Speach-BubbleComic','Speach-BubbleComic2'=>'Speach-BubbleComic2','Speach-BubbleComic3'=>'Speach-BubbleComic3','Speach-BubbleComic4'=>'Speach-BubbleComic4','Speach-BubbleDialog'=>'Speach-BubbleDialog','Speach-Bubbles'=>'Speach-Bubbles','Speak-2'=>'Speak-2','Speak'=>'Speak','Speaker-2'=>'Speaker-2','Speaker'=>'Speaker','Spell-Check'=>'Spell-Check','Spell-CheckABC'=>'Spell-CheckABC','Spermium'=>'Spermium','Spider'=>'Spider','Spiderweb'=>'Spiderweb','Split-FourSquareWindow'=>'Split-FourSquareWindow','Split-Horizontal'=>'Split-Horizontal','Split-Horizontal2Window'=>'Split-Horizontal2Window','Split-Vertical'=>'Split-Vertical','Split-Vertical2'=>'Split-Vertical2','Split-Window'=>'Split-Window','Spoder'=>'Spoder','Spoon'=>'Spoon','Sport-Mode'=>'Sport-Mode','Sports-Clothings1'=>'Sports-Clothings1','Sports-Clothings2'=>'Sports-Clothings2','Sports-Shirt'=>'Sports-Shirt','Spot'=>'Spot','Spray'=>'Spray','Spread'=>'Spread','Spring'=>'Spring','Spurl'=>'Spurl','Spy'=>'Spy','Squirrel'=>'Squirrel','SSL'=>'SSL','St-BasilsCathedral'=>'St-BasilsCathedral','St-PaulsCathedral'=>'St-PaulsCathedral','Stamp-2'=>'Stamp-2','Stamp'=>'Stamp','Stapler'=>'Stapler','Star-Track'=>'Star-Track','Star'=>'Star','Starfish'=>'Starfish','Start2'=>'Start2','Start-3'=>'Start-3','Start-ways'=>'Start-ways','Start'=>'Start','Statistic'=>'Statistic','Stethoscope'=>'Stethoscope','stop--2'=>'stop--2','Stop-Music'=>'Stop-Music','Stop'=>'Stop','Stopwatch-2'=>'Stopwatch-2','Stopwatch'=>'Stopwatch','Storm'=>'Storm','Street-View'=>'Street-View','Street-View2'=>'Street-View2','Strikethrough-Text'=>'Strikethrough-Text','Stroller'=>'Stroller','Structure'=>'Structure','Student-Female'=>'Student-Female','Student-Hat'=>'Student-Hat','Student-Hat2'=>'Student-Hat2','Student-Male'=>'Student-Male','Student-MaleFemale'=>'Student-MaleFemale','Students'=>'Students','Studio-Flash'=>'Studio-Flash','Studio-Lightbox'=>'Studio-Lightbox','Stumbleupon'=>'Stumbleupon','Suit'=>'Suit','Suitcase'=>'Suitcase','Sum-2'=>'Sum-2','Sum'=>'Sum','Summer'=>'Summer','Sun-CloudyRain'=>'Sun-CloudyRain','Sun'=>'Sun','Sunglasses-2'=>'Sunglasses-2','Sunglasses-3'=>'Sunglasses-3','Sunglasses-Smiley'=>'Sunglasses-Smiley','Sunglasses-Smiley2'=>'Sunglasses-Smiley2','Sunglasses-W'=>'Sunglasses-W','Sunglasses-W2'=>'Sunglasses-W2','Sunglasses-W3'=>'Sunglasses-W3','Sunglasses'=>'Sunglasses','Sunrise'=>'Sunrise','Sunset'=>'Sunset','Superman'=>'Superman','Support'=>'Support','Surprise'=>'Surprise','Sushi'=>'Sushi','Sweden'=>'Sweden','Swimming-Short'=>'Swimming-Short','Swimming'=>'Swimming','Swimmwear'=>'Swimmwear','Switch'=>'Switch','Switzerland'=>'Switzerland','Sync-Cloud'=>'Sync-Cloud','Sync'=>'Sync','Synchronize-2'=>'Synchronize-2','Synchronize'=>'Synchronize','T-Shirt'=>'T-Shirt','Tablet-2'=>'Tablet-2','Tablet-3'=>'Tablet-3','Tablet-Orientation'=>'Tablet-Orientation','Tablet-Phone'=>'Tablet-Phone','Tablet-Secure'=>'Tablet-Secure','Tablet-Vertical'=>'Tablet-Vertical','Tablet'=>'Tablet','Tactic'=>'Tactic','Tag-2'=>'Tag-2','Tag-3'=>'Tag-3','Tag-4'=>'Tag-4','Tag-5'=>'Tag-5','Tag'=>'Tag','Taj-Mahal'=>'Taj-Mahal','Talk-Man'=>'Talk-Man','Tap'=>'Tap','Target-Market'=>'Target-Market','Target'=>'Target','Taurus-2'=>'Taurus-2','Taurus'=>'Taurus','Taxi-2'=>'Taxi-2','Taxi-Sign'=>'Taxi-Sign','Taxi'=>'Taxi','Teacher'=>'Teacher','Teapot'=>'Teapot','Technorati'=>'Technorati','Teddy-Bear'=>'Teddy-Bear','Tee-Mug'=>'Tee-Mug','Telephone-2'=>'Telephone-2','Telephone'=>'Telephone','Telescope'=>'Telescope','Temperature-2'=>'Temperature-2','Temperature-3'=>'Temperature-3','Temperature'=>'Temperature','Temple'=>'Temple','Tennis-Ball'=>'Tennis-Ball','Tennis'=>'Tennis','Tent'=>'Tent','Test-Tube'=>'Test-Tube','Test-Tube2'=>'Test-Tube2','Testimonal'=>'Testimonal','Text-Box'=>'Text-Box','Text-Effect'=>'Text-Effect','Text-HighlightColor'=>'Text-HighlightColor','Text-Paragraph'=>'Text-Paragraph','Thailand'=>'Thailand','The-WhiteHouse'=>'The-WhiteHouse','This-SideUp'=>'This-SideUp','Thread'=>'Thread','Three-ArrowFork'=>'Three-ArrowFork','Three-Fingers'=>'Three-Fingers','Three-FingersDrag'=>'Three-FingersDrag','Three-FingersDrag2'=>'Three-FingersDrag2','Three-FingersTouch'=>'Three-FingersTouch','Thumb'=>'Thumb','Thumbs-DownSmiley'=>'Thumbs-DownSmiley','Thumbs-UpSmiley'=>'Thumbs-UpSmiley','Thunder'=>'Thunder','Thunderstorm'=>'Thunderstorm','Ticket'=>'Ticket','Tie-2'=>'Tie-2','Tie-3'=>'Tie-3','Tie-4'=>'Tie-4','Tie'=>'Tie','Tiger'=>'Tiger','Time-Backup'=>'Time-Backup','Time-Bomb'=>'Time-Bomb','Time-Clock'=>'Time-Clock','Time-Fire'=>'Time-Fire','Time-Machine'=>'Time-Machine','Time-Window'=>'Time-Window','Timer-2'=>'Timer-2','Timer'=>'Timer','To-Bottom'=>'To-Bottom','To-Bottom2'=>'To-Bottom2','To-Left'=>'To-Left','To-Right'=>'To-Right','To-Top'=>'To-Top','To-Top2'=>'To-Top2','Token-'=>'Token-','Tomato'=>'Tomato','Tongue'=>'Tongue','Tooth-2'=>'Tooth-2','Tooth'=>'Tooth','Top-ToBottom'=>'Top-ToBottom','Touch-Window'=>'Touch-Window','Tourch'=>'Tourch','Tower-2'=>'Tower-2','Tower-Bridge'=>'Tower-Bridge','Tower'=>'Tower','Trace'=>'Trace','Tractor'=>'Tractor','traffic-Light'=>'traffic-Light','Traffic-Light2'=>'Traffic-Light2','Train-2'=>'Train-2','Train'=>'Train','Tram'=>'Tram','Transform-2'=>'Transform-2','Transform-3'=>'Transform-3','Transform-4'=>'Transform-4','Transform'=>'Transform','Trash-withMen'=>'Trash-withMen','Tree-2'=>'Tree-2','Tree-3'=>'Tree-3','Tree-4'=>'Tree-4','Tree-5'=>'Tree-5','Tree'=>'Tree','Trekking'=>'Trekking','Triangle-ArrowDown'=>'Triangle-ArrowDown','Triangle-ArrowLeft'=>'Triangle-ArrowLeft','Triangle-ArrowRight'=>'Triangle-ArrowRight','Triangle-ArrowUp'=>'Triangle-ArrowUp','Tripod-2'=>'Tripod-2','Tripod-andVideo'=>'Tripod-andVideo','Tripod-withCamera'=>'Tripod-withCamera','Tripod-withGopro'=>'Tripod-withGopro','Trophy-2'=>'Trophy-2','Trophy'=>'Trophy','Truck'=>'Truck','Trumpet'=>'Trumpet','Tumblr'=>'Tumblr','Turkey'=>'Turkey','Turn-Down'=>'Turn-Down','Turn-Down2'=>'Turn-Down2','Turn-DownFromLeft'=>'Turn-DownFromLeft','Turn-DownFromRight'=>'Turn-DownFromRight','Turn-Left'=>'Turn-Left','Turn-Left3'=>'Turn-Left3','Turn-Right'=>'Turn-Right','Turn-Right3'=>'Turn-Right3','Turn-Up'=>'Turn-Up','Turn-Up2'=>'Turn-Up2','Turtle'=>'Turtle','Tuxedo'=>'Tuxedo','TV'=>'TV','Twister'=>'Twister','Twitter-2'=>'Twitter-2','Twitter'=>'Twitter','Two-Fingers'=>'Two-Fingers','Two-FingersDrag'=>'Two-FingersDrag','Two-FingersDrag2'=>'Two-FingersDrag2','Two-FingersScroll'=>'Two-FingersScroll','Two-FingersTouch'=>'Two-FingersTouch','Two-Windows'=>'Two-Windows','Type-Pass'=>'Type-Pass','Ukraine'=>'Ukraine','Umbrela'=>'Umbrela','Umbrella-2'=>'Umbrella-2','Umbrella-3'=>'Umbrella-3','Under-LineText'=>'Under-LineText','Undo'=>'Undo','United-Kingdom'=>'United-Kingdom','United-States'=>'United-States','University-2'=>'University-2','University'=>'University','Unlike-2'=>'Unlike-2','Unlike'=>'Unlike','Unlock-2'=>'Unlock-2','Unlock-3'=>'Unlock-3','Unlock'=>'Unlock','Up--Down'=>'Up--Down','Up--Down3'=>'Up--Down3','Up-2'=>'Up-2','Up-3'=>'Up-3','Up-4'=>'Up-4','Up'=>'Up','Upgrade'=>'Upgrade','Upload-2'=>'Upload-2','Upload-toCloud'=>'Upload-toCloud','Upload-Window'=>'Upload-Window','Upload'=>'Upload','Uppercase-Text'=>'Uppercase-Text','Upward'=>'Upward','URL-Window'=>'URL-Window','Usb-2'=>'Usb-2','Usb-Cable'=>'Usb-Cable','Usb'=>'Usb','User'=>'User','Ustream'=>'Ustream','Vase'=>'Vase','Vector-2'=>'Vector-2','Vector-3'=>'Vector-3','Vector-4'=>'Vector-4','Vector-5'=>'Vector-5','Vector'=>'Vector','Venn-Diagram'=>'Venn-Diagram','Vest-2'=>'Vest-2','Vest'=>'Vest','Viddler'=>'Viddler','Video-2'=>'Video-2','Video-3'=>'Video-3','Video-4'=>'Video-4','Video-5'=>'Video-5','Video-6'=>'Video-6','Video-GameController'=>'Video-GameController','Video-Len'=>'Video-Len','Video-Len2'=>'Video-Len2','Video-Photographer'=>'Video-Photographer','Video-Tripod'=>'Video-Tripod','Video'=>'Video','Vietnam'=>'Vietnam','View-Height'=>'View-Height','View-Width'=>'View-Width','Vimeo'=>'Vimeo','Virgo-2'=>'Virgo-2','Virgo'=>'Virgo','Virus-2'=>'Virus-2','Virus-3'=>'Virus-3','Virus'=>'Virus','Visa'=>'Visa','Voice'=>'Voice','Voicemail'=>'Voicemail','Volleyball'=>'Volleyball','Volume-Down'=>'Volume-Down','Volume-Up'=>'Volume-Up','VPN'=>'VPN','Wacom-Tablet'=>'Wacom-Tablet','Waiter'=>'Waiter','Walkie-Talkie'=>'Walkie-Talkie','Wallet-2'=>'Wallet-2','Wallet-3'=>'Wallet-3','Wallet'=>'Wallet','Warehouse'=>'Warehouse','Warning-Window'=>'Warning-Window','Watch-2'=>'Watch-2','Watch-3'=>'Watch-3','Watch'=>'Watch','Wave-2'=>'Wave-2','Wave'=>'Wave','Webcam'=>'Webcam','weight-Lift'=>'weight-Lift','Wheelbarrow'=>'Wheelbarrow','Wheelchair'=>'Wheelchair','Width-Window'=>'Width-Window','Wifi-2'=>'Wifi-2','Wifi-Keyboard'=>'Wifi-Keyboard','Wifi'=>'Wifi','Wind-Turbine'=>'Wind-Turbine','Windmill'=>'Windmill','Window-2'=>'Window-2','Window'=>'Window','Windows-2'=>'Windows-2','Windows-Microsoft'=>'Windows-Microsoft','Windows'=>'Windows','Windsock'=>'Windsock','Windy'=>'Windy','Wine-Bottle'=>'Wine-Bottle','Wine-Glass'=>'Wine-Glass','Wink'=>'Wink','Winter-2'=>'Winter-2','Winter'=>'Winter','Wireless'=>'Wireless','Witch-Hat'=>'Witch-Hat','Witch'=>'Witch','Wizard'=>'Wizard','Wolf'=>'Wolf','Woman-Sign'=>'Woman-Sign','WomanMan'=>'WomanMan','Womans-Underwear'=>'Womans-Underwear','Womans-Underwear2'=>'Womans-Underwear2','Women'=>'Women','Wonder-Woman'=>'Wonder-Woman','Wordpress'=>'Wordpress','Worker-Clothes'=>'Worker-Clothes','Worker'=>'Worker','Wrap-Text'=>'Wrap-Text','Wreath'=>'Wreath','Wrench'=>'Wrench','X-Box'=>'X-Box','X-ray'=>'X-ray','Xanga'=>'Xanga','Xing'=>'Xing','Yacht'=>'Yacht','Yahoo-Buzz'=>'Yahoo-Buzz','Yahoo'=>'Yahoo','Yelp'=>'Yelp','Yes'=>'Yes','Ying-Yang'=>'Ying-Yang','Youtube'=>'Youtube','Z-A'=>'Z-A','Zebra'=>'Zebra','Zombie'=>'Zombie','Zoom-Gesture'=>'Zoom-Gesture','Zootool'=>'Zootool');
	return apply_filters( 'ttbase_framework_shortcodes_iconsmind_font_icons_array', $iconsmind_font_icons );
}
// Map Icons
function ttbase_framework_shortcodes_map_icons_array() {
	$ttbase_framework_map_icons_array = array ('abseiling','accounting','airport','amusement-park','aquarium','archery','art-gallery','assistive-listening-system','atm','audio-description','bakery','bank','bar','baseball','beauty-salon','bicycle-store','bicycling','boat-ramp','boat-tour','boating','book-store','bowling-alley','braille','bus-station','cafe','campground','canoe','car-dealer','car-rental','car-repair','car-wash','casino','cemetery','chairlift','church','circle','city-hall','climbing','closed-captioning','clothing-store','compass','convenience-store','courthouse','cross-country-skiing','crosshairs','dentist','department-store','diving','doctor','electrician','electronics-store','embassy','expand','female','finance','fire-station','fish-cleaning','fishing-pier','fishing','florist','food','fullscreen','funeral-home','furniture-store','gas-station','general-contractor','golf','grocery-or-supermarket','gym','hair-care','hang-gliding','hardware-store','health','hindu-temple','horse-riding','hospital','ice-fishing','ice-skating','inline-skating','insurance-agency','jet-skiing','jewelry-store','kayaking','laundry','lawyer','library','liquor-store','local-government','location-arrow','locksmith','lodging','low-vision-access','male','map-pin','marina','mosque','motobike-trail','movie-rental','movie-theater','moving-company','museum','natural-feature','night-club','open-captioning','painter','park','parking','pet-store','pharmacy','physiotherapist','place-of-worship','playground','plumber','point-of-interest','police','political','post-box','post-office','postal-code-prefix','postal-code','rafting','real-estate-agency','restaurant','roofing-contractor','route-pin','route','rv-park','sailing','school','scuba-diving','search','shield','shopping-mall','sign-language','skateboarding','ski-jumping','skiing','sledding','snow-shoeing','snow','snowboarding','snowmobile','spa','square-pin','square-rounded','square','stadium','storage','store','subway-station','surfing','swimming','synagogue','taxi-stand','tennis','toilet','trail-walking','train-station','transit-station','travel-agency','unisex','university','veterinary-care','viewing','volume-control-telephone','walking','waterskiing','whale-watching','wheelchair','wind-surfing','zoo','zoom-in-alt','zoom-in','zoom-out-alt','zoom-out');
	$ttbase_framework_map_icons_array = array_combine($ttbase_framework_map_icons_array,$ttbase_framework_map_icons_array);
	return apply_filters( 'ttbase_framework_shortcodes_map_icons_array', $ttbase_framework_map_icons_array );
}
// Social Icons
function ttbase_framework_shortcodes_social_icons_array() {
	$ttbase_social_icons_array = array ('dribbble','facebook','flickr','forrst','github','googleplus','instagram','linkedin','pinterest','rss','tumblr','twitter','vimeo','youtube');
	$ttbase_social_icons_array = array_combine($ttbase_social_icons_array,$ttbase_social_icons_array);
	return apply_filters( 'ttbase_framework_shortcodes_social_icons_array', $ttbase_social_icons_array );
}

// CSS Animations
function ttbase_framework_shortcodes_css_animations_array() {
	$css_animations = array(
		esc_html__( 'No', 'ttbase-framework' )  => '',
		esc_html__( 'From Bottom', 'ttbase-framework' )    	=> 'has-animation from-bottom',
		esc_html__( 'From Top', 'ttbase-framework' )   		=> 'has-animation from-top',
		esc_html__( 'From Left', 'ttbase-framework' )    	=> 'has-animation from-left',
		esc_html__( 'From Right', 'ttbase-framework' )    	=> 'has-animation from-right',
		esc_html__( 'Fade In', 'ttbase-framework' )    		=> 'has-animation fade',
	);
	return apply_filters( 'ttbase_framework_shortcodes_css_animations_array', $css_animations );
}

// Button Sizes
function ttbase_framework_shortcodes_button_sizes_array() {
	$button_sizes = array(
		esc_html__( 'Default', 'ttbase-framework' )  => '',
		esc_html__( 'Small', 'ttbase-framework' )    => 'btn-small',
		esc_html__( 'Medium', 'ttbase-framework' )   => 'btn-medium',
		esc_html__( 'Large', 'ttbase-framework' )    => 'btn-large',
	);
	return apply_filters( 'ttbase_framework_shortcodes_button_sizes_array', $button_sizes );
}

// Order By
function ttbase_framework_shortcodes_order_by_array() {
	$order_by = array(
		 esc_html__( 'Date', 'ttbase-framework' )           => 'date',
		 esc_html__( 'Name', 'ttbase-framework' )          => 'name',
		 esc_html__( 'Modified', 'ttbase-framework' )       => 'modified',
		 esc_html__( 'Author', 'ttbase-framework' )        => 'author',
		 esc_html__( 'Random', 'ttbase-framework' )         => 'random',
		 esc_html__( 'Comment Count', 'ttbase-framework' ) => 'comment_count',
	);
	return apply_filters( 'ttbase_framework_shortcodes_order_by_array', $order_by );
}

// Order By for Services
function ttbase_framework_shortcodes_services_order_by_array() {
	$order_by = array(
		 esc_html__( 'Date', 'ttbase-framework' )           => 'date',
		 esc_html__( 'Name', 'ttbase-framework' )          => 'name',
		 esc_html__( 'Random', 'ttbase-framework' )         => 'random',
	);
	return apply_filters( 'ttbase_framework_shortcodes_services_order_by_array', $order_by );
}

// Post Types
function ttbase_framework_shortcodes_get_post_types() {
	$array = array();
	$post_types = get_post_types( array( 'public' => true ), 'names' ); 
	foreach ( $post_types as $post_type ) {
		if ( $post_type !== 'attachment' ) {
			$array[] = $post_type;
		}
	}
	$array = array_combine( $array, $array );
	return $array;
}

// Taxonomies
function ttbase_framework_shortcodes_get_taxonomies() {
	$array = array();
	$taxonomies = get_taxonomies();
	foreach ( $taxonomies as $taxonomy ) {
		$array[] = $taxonomy;
	}
	$array = array_combine( $array, $array );
	return $array;
}