<?php
/**
 * Getting started section.
 *
 * @package    Meta Box
 * @subpackage MB Custom Post Type
 */

?>
<div id="getting-started" class="gt-tab-pane gt-is-active">
	<div class="feature-section two-col">
		<div class="col">
			<h3><?php esc_html_e( 'Getting Started With Online Generator', 'meta-box' ); ?></h3>
			<p><?php esc_html_e( 'The fastest way to getting started with Meta Box is use our online generator to generate meta boxes with custom fields. It provides a friendly UI for you to create meta boxes and custom fields just by drag and drop fields.', 'meta-box' ); ?><p>

			<a class="screenshot" href="https://metabox.io/online-generator/?utm_source=plugin_about_page&utm_medium=link_generator&utm_campaign=meta_box_about_page" target="_blank"><img src="<?php echo esc_url( RWMB_URL . 'inc/about/images/online-generator.png' ); ?>" alt="<?php esc_attr_e( 'online generator', 'meta-box' ); ?>"></a>

			<p><a href="<?php echo esc_url( 'https://metabox.io/online-generator/?utm_source=plugin_about_page&utm_medium=button_generator&utm_campaign=meta_box_about_page' ); ?>" class="button button-primary"><?php esc_html_e( 'Go to Online Generator', 'meta-box' ); ?></a></p>
		</div>

		<div class="col">
			<h3><?php esc_html_e( 'Understand The Basics', 'meta-box' ); ?></h3>
			<p><?php esc_html_e( 'Meta Box doesn\'t have any admin page for configuration or settings. Instead of that, it provides a very powerful API to speed up the process of creating meta boxes and custom fields. It might take you a little time at first, but then you\'ll love the way it work because it helps you do and customize almost everything.', 'meta-box' ); ?><p>
			<p><a href="<?php echo esc_url( 'https://docs.metabox.io/quick-start/?utm_source=plugin_about_page&utm_medium=button_docs&utm_campaign=meta_box_about_page' ); ?>" class="button button-primary"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a></p>

			<h3><?php esc_html_e( 'Extensions', 'meta-box' ); ?></h3>
			<p><?php esc_html_e( 'Wanna see more features that transform your WordPress website into a powerful CMS? Check out some extensions below:', 'meta-box' ); ?><p>
			<ul>
				<li><a target="_blank" href="https://metabox.io/plugins/meta-box-group/?utm_source=plugin_about_page&utm_medium=link_group&utm_campaign=meta_box_about_page"><span class="dashicons dashicons-welcome-widgets-menus"></span> <?php esc_html_e( 'Meta Box Group', 'meta-box' ); ?></a></li>
				<li><a target="_blank" href="https://metabox.io/plugins/meta-box-conditional-logic/?utm_source=plugin_about_page&utm_medium=link_conditional&utm_campaign=meta_box_about_page"><span class="dashicons dashicons-yes"></span> <?php esc_html_e( 'Meta Box Conditional Logic', 'meta-box' ); ?></a></li>
				<li><a target="_blank" href="https://metabox.io/plugins/mb-settings-page/?utm_source=plugin_about_page&utm_medium=link_settings&utm_campaign=meta_box_about_page"><span class="dashicons dashicons-admin-generic"></span> <?php esc_html_e( 'MB Settings Page', 'meta-box' ); ?></a></li>
				<li><a target="_blank" href="https://metabox.io/plugins/mb-term-meta/?utm_source=plugin_about_page&utm_medium=link_term&utm_campaign=meta_box_about_page"><span class="dashicons dashicons-image-filter"></span> <?php esc_html_e( 'MB Term Meta', 'meta-box' ); ?></a></li>
			</ul>
			<p><a target="_blank" class="button button-primary" href="https://metabox.io/plugins/?utm_source=plugin_about_page&utm_medium=button_extensions&utm_campaign=meta_box_about_page"><?php esc_html_e( 'More Extensions', 'meta-box' ); ?></a>
		</div>
	</div>
	<hr>
	<div class="return-to-dashboard">
		<a href="https://metabox.io/plugins/?utm_source=plugin_about_page&utm_medium=link_home&utm_campaign=meta_box_about_page"><?php esc_html_e( 'Go to MetaBox.IO &rarr;', 'meta-box' ); ?></a>
	</div>
</div>
